/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.renderer.layer;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.renderer.GeoArmorRenderer;
import mod.azure.azurelib.renderer.GeoRenderer;
import mod.azure.azurelib.renderer.layer.GeoRenderLayer;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.ForgeHooksClient;

@Deprecated
public class ItemArmorGeoLayer<T extends LivingEntity>
extends GeoRenderLayer<T> {
    protected static final Map<String, ResourceLocation> ARMOR_PATH_CACHE = new Object2ObjectOpenHashMap();
    protected static final BipedModel<LivingEntity> INNER_ARMOR_MODEL = new BipedModel(0.5f);
    protected static final BipedModel<LivingEntity> OUTER_ARMOR_MODEL = new BipedModel(1.0f);
    @Nullable
    protected ItemStack mainHandStack;
    @Nullable
    protected ItemStack offhandStack;
    @Nullable
    protected ItemStack helmetStack;
    @Nullable
    protected ItemStack chestplateStack;
    @Nullable
    protected ItemStack leggingsStack;
    @Nullable
    protected ItemStack bootsStack;

    public ItemArmorGeoLayer(GeoRenderer<T> geoRenderer) {
        super(geoRenderer);
    }

    @Nonnull
    protected EquipmentSlotType getEquipmentSlotForBone(GeoBone bone, ItemStack stack, T animatable) {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR || stack != animatable.func_184582_a(slot)) continue;
            return slot;
        }
        return EquipmentSlotType.CHEST;
    }

    @Nonnull
    protected ModelRenderer getModelPartForBone(GeoBone bone, EquipmentSlotType slot, ItemStack stack, T animatable, BipedModel<?> baseModel) {
        return baseModel.field_78115_e;
    }

    @Nullable
    protected ItemStack getArmorItemForBone(GeoBone bone, T animatable) {
        return null;
    }

    @Override
    public void preRender(MatrixStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, IRenderTypeBuffer bufferSource, IVertexBuilder buffer, float partialTick, int packedLight, int packedOverlay) {
        this.mainHandStack = animatable.func_184582_a(EquipmentSlotType.MAINHAND);
        this.offhandStack = animatable.func_184582_a(EquipmentSlotType.OFFHAND);
        this.helmetStack = animatable.func_184582_a(EquipmentSlotType.HEAD);
        this.chestplateStack = animatable.func_184582_a(EquipmentSlotType.CHEST);
        this.leggingsStack = animatable.func_184582_a(EquipmentSlotType.LEGS);
        this.bootsStack = animatable.func_184582_a(EquipmentSlotType.FEET);
    }

    @Override
    public void renderForBone(MatrixStack poseStack, T animatable, GeoBone bone, RenderType renderType, IRenderTypeBuffer bufferSource, IVertexBuilder buffer, float partialTick, int packedLight, int packedOverlay) {
        ItemStack armorStack = this.getArmorItemForBone(bone, animatable);
        if (armorStack == null) {
            return;
        }
        if (armorStack.func_77973_b() instanceof BlockItem && ((BlockItem)armorStack.func_77973_b()).func_179223_d() instanceof AbstractSkullBlock) {
            this.renderSkullAsArmor(poseStack, bone, armorStack, (AbstractSkullBlock)((BlockItem)armorStack.func_77973_b()).func_179223_d(), bufferSource, packedLight);
        } else {
            EquipmentSlotType slot = this.getEquipmentSlotForBone(bone, armorStack, animatable);
            BipedModel<?> model = this.getModelForItem(bone, slot, armorStack, animatable);
            ModelRenderer modelPart = this.getModelPartForBone(bone, slot, armorStack, animatable, model);
            if (!modelPart.field_78804_l.isEmpty()) {
                poseStack.func_227860_a_();
                poseStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
                if (model instanceof GeoArmorRenderer) {
                    this.prepModelPartForRender(poseStack, bone, modelPart);
                    ((GeoArmorRenderer)model).prepForRender((Entity)animatable, armorStack, slot, model);
                    ((GeoArmorRenderer)model).applyBoneVisibilityByPart(slot, modelPart, model);
                    model.func_225598_a_(poseStack, null, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                } else if (armorStack.func_77973_b() instanceof ArmorItem) {
                    this.prepModelPartForRender(poseStack, bone, modelPart);
                    this.renderVanillaArmorPiece(poseStack, animatable, bone, slot, armorStack, modelPart, bufferSource, partialTick, packedLight, packedOverlay);
                }
                poseStack.func_227865_b_();
            }
        }
    }

    protected <I extends Item> void renderVanillaArmorPiece(MatrixStack poseStack, T animatable, GeoBone bone, EquipmentSlotType slot, ItemStack armorStack, ModelRenderer modelPart, IRenderTypeBuffer bufferSource, float partialTick, int packedLight, int packedOverlay) {
        ResourceLocation texture = this.getVanillaArmorResource((Entity)animatable, armorStack, slot, "");
        IVertexBuilder buffer = this.getArmorBuffer(bufferSource, null, texture, armorStack.func_77962_s());
        if (armorStack.func_77973_b() instanceof DyeableArmorItem) {
            int color = ((DyeableArmorItem)armorStack.func_77973_b()).func_200886_f(armorStack);
            modelPart.func_228309_a_(poseStack, buffer, packedLight, packedOverlay, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f);
            texture = this.getVanillaArmorResource((Entity)animatable, armorStack, slot, "overlay");
            buffer = this.getArmorBuffer(bufferSource, null, texture, false);
        }
        modelPart.func_228309_a_(poseStack, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected IVertexBuilder getArmorBuffer(IRenderTypeBuffer bufferSource, @Nullable RenderType renderType, @Nullable ResourceLocation texturePath, boolean enchanted) {
        if (renderType == null) {
            renderType = RenderType.func_228640_c_((ResourceLocation)texturePath);
        }
        return ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferSource, (RenderType)renderType, (boolean)false, (boolean)enchanted);
    }

    @Nonnull
    protected BipedModel<?> getModelForItem(GeoBone bone, EquipmentSlotType slot, ItemStack stack, T animatable) {
        BipedModel<LivingEntity> defaultModel = slot == EquipmentSlotType.LEGS ? INNER_ARMOR_MODEL : OUTER_ARMOR_MODEL;
        return stack.func_77973_b().getArmorModel(animatable, stack, slot, defaultModel);
    }

    public ResourceLocation getVanillaArmorResource(Entity entity, ItemStack stack, EquipmentSlotType slot, String type) {
        String domain = "minecraft";
        String path = ((ArmorItem)stack.func_77973_b()).func_200880_d().func_200897_d();
        String[] materialNameSplit = path.split(":", 2);
        if (materialNameSplit.length > 1) {
            domain = materialNameSplit[0];
            path = materialNameSplit[1];
        }
        if (!type.isEmpty()) {
            type = "_" + type;
        }
        String texture = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, path, slot == EquipmentSlotType.LEGS ? 2 : 1, type);
        texture = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)texture, (EquipmentSlotType)slot, (String)type);
        return ARMOR_PATH_CACHE.computeIfAbsent(texture, ResourceLocation::new);
    }

    protected void renderSkullAsArmor(MatrixStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, IRenderTypeBuffer bufferSource, int packedLight) {
        GameProfile skullProfile = null;
        if (stack.func_77942_o()) {
            String s;
            CompoundNBT compoundnbt = stack.func_77978_p();
            if (compoundnbt.func_150297_b("SkullOwner", 10)) {
                skullProfile = NBTUtil.func_152459_a((CompoundNBT)compoundnbt.func_74775_l("SkullOwner"));
            } else if (compoundnbt.func_150297_b("SkullOwner", 8) && !StringUtils.func_151246_b((String)(s = compoundnbt.func_74779_i("SkullOwner")))) {
                skullProfile = SkullTileEntity.func_174884_b((GameProfile)new GameProfile(null, s));
                compoundnbt.func_218657_a("SkullOwner", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)skullProfile));
            }
        }
        poseStack.func_227860_a_();
        RenderUtils.translateAndRotateMatrixForBone(poseStack, bone);
        poseStack.func_227862_a_(1.1875f, 1.1875f, 1.1875f);
        poseStack.func_227861_a_(-0.5, 0.0, -0.5);
        SkullTileEntityRenderer.func_228879_a_(null, (float)0.0f, (SkullBlock.ISkullType)((AbstractSkullBlock)((BlockItem)stack.func_77973_b()).func_179223_d()).func_196292_N_(), (GameProfile)skullProfile, (float)0.0f, (MatrixStack)poseStack, (IRenderTypeBuffer)bufferSource, (int)packedLight);
        poseStack.func_227865_b_();
    }

    protected void prepModelPartForRender(MatrixStack poseStack, GeoBone bone, ModelRenderer sourcePart) {
        GeoCube firstCube = bone.getCubes().get(0);
        ModelRenderer.ModelBox armorCube = (ModelRenderer.ModelBox)sourcePart.field_78804_l.get(0);
        double armorBoneSizeX = firstCube.size().func_82615_a();
        double armorBoneSizeY = firstCube.size().func_82617_b();
        double armorBoneSizeZ = firstCube.size().func_82616_c();
        double actualArmorSizeX = Math.abs(armorCube.field_78248_d - armorCube.field_78252_a);
        double actualArmorSizeY = Math.abs(armorCube.field_78249_e - armorCube.field_78250_b);
        double actualArmorSizeZ = Math.abs(armorCube.field_78246_f - armorCube.field_78251_c);
        float scaleX = (float)(armorBoneSizeX / actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / actualArmorSizeZ);
        sourcePart.func_78793_a(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        sourcePart.field_78795_f = -bone.getRotX();
        sourcePart.field_78796_g = -bone.getRotY();
        sourcePart.field_78808_h = bone.getRotZ();
        poseStack.func_227862_a_(scaleX, scaleY, scaleZ);
    }
}

