/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.resource;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mod.azure.azurelib.resource.Pixel;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.JSONUtils;

public class GeoGlowingTextureMeta {
    public static final IMetadataSectionSerializer<GeoGlowingTextureMeta> DESERIALIZER = new IMetadataSectionSerializer<GeoGlowingTextureMeta>(){

        public String func_110483_a() {
            return "glowsections";
        }

        public GeoGlowingTextureMeta deserialize(JsonObject json) {
            List<Pixel> pixels = this.fromSections(JSONUtils.func_151213_a((JsonObject)json, (String)"sections", null));
            if (pixels.isEmpty()) {
                throw new JsonParseException("Empty glowlayer sections file. Must have at least one glow section!");
            }
            return new GeoGlowingTextureMeta(pixels);
        }

        private List<Pixel> fromSections(@Nullable JsonArray sectionsArray) {
            if (sectionsArray == null) {
                return new ObjectArrayList();
            }
            ObjectArrayList pixels = new ObjectArrayList();
            for (JsonElement element : sectionsArray) {
                if (!(element instanceof JsonObject)) {
                    throw new JsonParseException("Invalid glowsections json format, expected a JsonObject, found: " + element.getClass());
                }
                int x1 = JSONUtils.func_151208_a((JsonObject)((JsonObject)element), (String)"x1", (int)JSONUtils.func_151208_a((JsonObject)((JsonObject)element), (String)"x", (int)0));
                int y1 = JSONUtils.func_151208_a((JsonObject)((JsonObject)element), (String)"y1", (int)JSONUtils.func_151208_a((JsonObject)((JsonObject)element), (String)"y", (int)0));
                int x2 = JSONUtils.func_151208_a((JsonObject)((JsonObject)element), (String)"x2", (int)(JSONUtils.func_151208_a((JsonObject)((JsonObject)element), (String)"w", (int)0) + x1));
                int y2 = JSONUtils.func_151208_a((JsonObject)((JsonObject)element), (String)"y2", (int)(JSONUtils.func_151208_a((JsonObject)((JsonObject)element), (String)"h", (int)0) + y1));
                int alpha = JSONUtils.func_151208_a((JsonObject)((JsonObject)element), (String)"alpha", (int)JSONUtils.func_151208_a((JsonObject)((JsonObject)element), (String)"a", (int)0));
                if (x1 + y1 + x2 + y2 == 0) {
                    throw new IllegalArgumentException("Invalid glowsections section object, section must be at least one pixel in size");
                }
                for (int x = x1; x <= x2; ++x) {
                    for (int y = y1; y <= y2; ++y) {
                        pixels.add(new Pixel(x, y, alpha));
                    }
                }
            }
            return pixels;
        }
    };
    private final List<Pixel> pixels;

    public GeoGlowingTextureMeta(List<Pixel> pixels) {
        this.pixels = pixels;
    }

    public static GeoGlowingTextureMeta fromExistingImage(NativeImage glowLayer) {
        ObjectArrayList pixels = new ObjectArrayList();
        for (int x = 0; x < glowLayer.func_195702_a(); ++x) {
            for (int y = 0; y < glowLayer.func_195714_b(); ++y) {
                int color = glowLayer.func_195709_a(x, y);
                if (color == 0) continue;
                pixels.add(new Pixel(x, y, NativeImage.func_227786_a_((int)color)));
            }
        }
        if (pixels.isEmpty()) {
            throw new IllegalStateException("Invalid glow layer texture provided, must have at least one pixel!");
        }
        return new GeoGlowingTextureMeta((List<Pixel>)pixels);
    }

    public void createImageMask(NativeImage originalImage, NativeImage newImage) {
        for (Pixel pixel : this.pixels) {
            int color = originalImage.func_195709_a(pixel.x, pixel.y);
            if (pixel.alpha > 0) {
                color = NativeImage.func_227787_a_((int)pixel.alpha, (int)NativeImage.func_227795_d_((int)color), (int)NativeImage.func_227793_c_((int)color), (int)NativeImage.func_227791_b_((int)color));
            }
            newImage.func_195700_a(pixel.x, pixel.y, color);
            originalImage.func_195700_a(pixel.x, pixel.y, 0);
        }
    }
}

