/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public abstract class AzResourceCache {
    private static final List<String> EXCLUDED_NAMESPACES = Arrays.asList("geckolib3", "animatedmobsmod", "moreplayermodels", "dungeons_mobs", "customnpcs", "gunsrpg", "mimic", "celestisynth", "the_flesh_that_hates", "enemyexpansion", "mutationcraft", "born_in_chaos_v1");

    protected final <T> CompletableFuture<Void> loadResources(Executor executor, IResourceManager resourceManager, String type, Function<ResourceLocation, T> loader, BiConsumer<ResourceLocation, T> map) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> resourceManager.func_199003_a(type, fileName -> fileName.endsWith(".json")), executor).thenApplyAsync(resources -> {
            Object2ObjectOpenHashMap tasks = new Object2ObjectOpenHashMap();
            for (ResourceLocation resource : resources) {
                tasks.put((Object)resource, CompletableFuture.supplyAsync(() -> loader.apply(resource), executor));
            }
            return tasks;
        }, executor)).thenAcceptAsync(tasks -> {
            for (Map.Entry entry : tasks.entrySet()) {
                if (EXCLUDED_NAMESPACES.contains(((ResourceLocation)entry.getKey()).func_110624_b().toLowerCase(Locale.ROOT))) continue;
                map.accept((ResourceLocation)entry.getKey(), ((CompletableFuture)entry.getValue()).join());
            }
        }, executor);
    }
}

