/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation;

public class AzAnimatorConfig {
    private final double boneResetTime;
    private final boolean crashIfBoneMissing;
    private final boolean shouldPlayAnimationsWhileGamePaused;

    public AzAnimatorConfig(double boneResetTime, boolean crashIfBoneMissing, boolean shouldPlayAnimationsWhileGamePaused) {
        this.boneResetTime = boneResetTime;
        this.crashIfBoneMissing = crashIfBoneMissing;
        this.shouldPlayAnimationsWhileGamePaused = shouldPlayAnimationsWhileGamePaused;
    }

    public double boneResetTime() {
        return this.boneResetTime;
    }

    public boolean crashIfBoneMissing() {
        return this.crashIfBoneMissing;
    }

    public boolean shouldPlayAnimationsWhileGamePaused() {
        return this.shouldPlayAnimationsWhileGamePaused;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AzAnimatorConfig defaultConfig() {
        return AzAnimatorConfig.builder().build();
    }

    public static class Builder {
        private double boneResetTime = 1.0;
        private boolean crashIfBoneMissing = false;
        private boolean shouldPlayAnimationsWhileGamePaused = false;

        private Builder() {
        }

        public Builder crashIfBoneMissing() {
            this.crashIfBoneMissing = true;
            return this;
        }

        public Builder shouldPlayAnimationsWhileGamePaused() {
            this.shouldPlayAnimationsWhileGamePaused = true;
            return this;
        }

        public Builder withBoneResetTime(double boneResetTime) {
            this.boneResetTime = boneResetTime;
            return this;
        }

        public AzAnimatorConfig build() {
            return new AzAnimatorConfig(this.boneResetTime, this.crashIfBoneMissing, this.shouldPlayAnimationsWhileGamePaused);
        }
    }
}

