/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import mod.azure.azurelib.loading.FileLoader;
import mod.azure.azurelib.rewrite.AzResourceCache;
import mod.azure.azurelib.rewrite.animation.primitive.AzBakedAnimations;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class AzBakedAnimationCache
extends AzResourceCache {
    private static final AzBakedAnimationCache INSTANCE = new AzBakedAnimationCache();
    private final Map<ResourceLocation, AzBakedAnimations> bakedAnimations = new Object2ObjectOpenHashMap();

    public static AzBakedAnimationCache getInstance() {
        return INSTANCE;
    }

    private AzBakedAnimationCache() {
    }

    public CompletableFuture<Void> loadAnimations(Executor backgroundExecutor, IResourceManager resourceManager) {
        return this.loadResources(backgroundExecutor, resourceManager, "animations", resource -> FileLoader.loadAzAnimationsFile(resource, resourceManager), this.bakedAnimations::put);
    }

    public AzBakedAnimations getNullable(ResourceLocation resourceLocation) {
        return this.bakedAnimations.get(resourceLocation);
    }
}

