/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.controller;

import java.util.Objects;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.AzKeyframeCallbacks;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelib.rewrite.animation.property.AzAnimationProperties;

public class AzAnimationControllerBuilder<T> {
    private final AzAnimator<T> animator;
    private final String name;
    private AzAnimationProperties animationProperties;
    private AzKeyframeCallbacks<T> keyframeCallbacks;

    public AzAnimationControllerBuilder(AzAnimator<T> animator, String name) {
        this.animator = animator;
        this.name = name;
        this.animationProperties = AzAnimationProperties.DEFAULT;
        this.keyframeCallbacks = AzKeyframeCallbacks.noop();
    }

    public AzAnimationControllerBuilder<T> setAnimationSpeed(double animationSpeed) {
        this.animationProperties = this.animationProperties.withAnimationSpeed(animationSpeed);
        return this;
    }

    public AzAnimationControllerBuilder<T> setKeyframeCallbacks(AzKeyframeCallbacks<T> keyframeCallbacks) {
        Objects.requireNonNull(keyframeCallbacks);
        this.keyframeCallbacks = keyframeCallbacks;
        return this;
    }

    public AzAnimationControllerBuilder<T> setEasingType(AzEasingType easingType) {
        this.animationProperties = this.animationProperties.withEasingType(easingType);
        return this;
    }

    public AzAnimationControllerBuilder<T> setTransitionLength(int transitionLength) {
        this.animationProperties = this.animationProperties.withTransitionLength(transitionLength);
        return this;
    }

    public AzAnimationController<T> build() {
        return new AzAnimationController<T>(this.name, this.animator, this.animationProperties, this.keyframeCallbacks);
    }
}

