/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.controller.keyframe;

import mod.azure.azurelib.rewrite.animation.controller.keyframe.AzKeyframe;

public class AzAnimationPoint {
    private final AzKeyframe<?> keyframe;
    private final double currentTick;
    private final double transitionLength;
    private final double animationStartValue;
    private final double animationEndValue;

    public AzAnimationPoint(AzKeyframe<?> keyframe, double currentTick, double transitionLength, double animationStartValue, double animationEndValue) {
        this.keyframe = keyframe;
        this.currentTick = currentTick;
        this.transitionLength = transitionLength;
        this.animationStartValue = animationStartValue;
        this.animationEndValue = animationEndValue;
    }

    public AzKeyframe<?> keyframe() {
        return this.keyframe;
    }

    public double currentTick() {
        return this.currentTick;
    }

    public double transitionLength() {
        return this.transitionLength;
    }

    public double animationStartValue() {
        return this.animationStartValue;
    }

    public double animationEndValue() {
        return this.animationEndValue;
    }

    public String toString() {
        return "Tick: " + this.currentTick + " | Transition Length: " + this.transitionLength + " | Start Value: " + this.animationStartValue + " | End Value: " + this.animationEndValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzAnimationPoint that = (AzAnimationPoint)o;
        if (Double.compare(that.currentTick, this.currentTick) != 0) {
            return false;
        }
        if (Double.compare(that.transitionLength, this.transitionLength) != 0) {
            return false;
        }
        if (Double.compare(that.animationStartValue, this.animationStartValue) != 0) {
            return false;
        }
        if (Double.compare(that.animationEndValue, this.animationEndValue) != 0) {
            return false;
        }
        return this.keyframe != null ? this.keyframe.equals(that.keyframe) : that.keyframe == null;
    }

    public int hashCode() {
        int result = this.keyframe != null ? this.keyframe.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.currentTick);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.transitionLength);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.animationStartValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.animationEndValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

