/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.controller.keyframe;

import java.util.LinkedList;
import java.util.Queue;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.AzAnimationPoint;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.AzKeyframe;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.model.AzBoneSnapshot;

public class AzBoneAnimationQueue {
    private final AzBone bone;
    private final Queue<AzAnimationPoint> rotationXQueue;
    private final Queue<AzAnimationPoint> rotationYQueue;
    private final Queue<AzAnimationPoint> rotationZQueue;
    private final Queue<AzAnimationPoint> positionXQueue;
    private final Queue<AzAnimationPoint> positionYQueue;
    private final Queue<AzAnimationPoint> positionZQueue;
    private final Queue<AzAnimationPoint> scaleXQueue;
    private final Queue<AzAnimationPoint> scaleYQueue;
    private final Queue<AzAnimationPoint> scaleZQueue;

    public AzBoneAnimationQueue(AzBone bone) {
        this(bone, new LinkedList<AzAnimationPoint>(), new LinkedList<AzAnimationPoint>(), new LinkedList<AzAnimationPoint>(), new LinkedList<AzAnimationPoint>(), new LinkedList<AzAnimationPoint>(), new LinkedList<AzAnimationPoint>(), new LinkedList<AzAnimationPoint>(), new LinkedList<AzAnimationPoint>(), new LinkedList<AzAnimationPoint>());
    }

    public AzBoneAnimationQueue(AzBone bone, Queue<AzAnimationPoint> rotationXQueue, Queue<AzAnimationPoint> rotationYQueue, Queue<AzAnimationPoint> rotationZQueue, Queue<AzAnimationPoint> positionXQueue, Queue<AzAnimationPoint> positionYQueue, Queue<AzAnimationPoint> positionZQueue, Queue<AzAnimationPoint> scaleXQueue, Queue<AzAnimationPoint> scaleYQueue, Queue<AzAnimationPoint> scaleZQueue) {
        this.bone = bone;
        this.rotationXQueue = rotationXQueue;
        this.rotationYQueue = rotationYQueue;
        this.rotationZQueue = rotationZQueue;
        this.positionXQueue = positionXQueue;
        this.positionYQueue = positionYQueue;
        this.positionZQueue = positionZQueue;
        this.scaleXQueue = scaleXQueue;
        this.scaleYQueue = scaleYQueue;
        this.scaleZQueue = scaleZQueue;
    }

    public AzBone bone() {
        return this.bone;
    }

    public Queue<AzAnimationPoint> rotationXQueue() {
        return this.rotationXQueue;
    }

    public Queue<AzAnimationPoint> rotationYQueue() {
        return this.rotationYQueue;
    }

    public Queue<AzAnimationPoint> rotationZQueue() {
        return this.rotationZQueue;
    }

    public Queue<AzAnimationPoint> positionXQueue() {
        return this.positionXQueue;
    }

    public Queue<AzAnimationPoint> positionYQueue() {
        return this.positionYQueue;
    }

    public Queue<AzAnimationPoint> positionZQueue() {
        return this.positionZQueue;
    }

    public Queue<AzAnimationPoint> scaleXQueue() {
        return this.scaleXQueue;
    }

    public Queue<AzAnimationPoint> scaleYQueue() {
        return this.scaleYQueue;
    }

    public Queue<AzAnimationPoint> scaleZQueue() {
        return this.scaleZQueue;
    }

    public void addPosXPoint(AzKeyframe<?> keyframe, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.positionXQueue.add(new AzAnimationPoint(keyframe, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addPosYPoint(AzKeyframe<?> keyframe, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.positionYQueue.add(new AzAnimationPoint(keyframe, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addPosZPoint(AzKeyframe<?> keyframe, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.positionZQueue.add(new AzAnimationPoint(keyframe, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addNextPosition(AzKeyframe<?> keyframe, double lerpedTick, double transitionLength, AzBoneSnapshot startSnapshot, AzAnimationPoint nextXPoint, AzAnimationPoint nextYPoint, AzAnimationPoint nextZPoint) {
        this.addPosXPoint(keyframe, lerpedTick, transitionLength, startSnapshot.getOffsetX(), nextXPoint.animationStartValue());
        this.addPosYPoint(keyframe, lerpedTick, transitionLength, startSnapshot.getOffsetY(), nextYPoint.animationStartValue());
        this.addPosZPoint(keyframe, lerpedTick, transitionLength, startSnapshot.getOffsetZ(), nextZPoint.animationStartValue());
    }

    public void addScaleXPoint(AzKeyframe<?> keyframe, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.scaleXQueue.add(new AzAnimationPoint(keyframe, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addScaleYPoint(AzKeyframe<?> keyframe, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.scaleYQueue.add(new AzAnimationPoint(keyframe, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addScaleZPoint(AzKeyframe<?> keyframe, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.scaleZQueue.add(new AzAnimationPoint(keyframe, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addNextScale(AzKeyframe<?> keyframe, double lerpedTick, double transitionLength, AzBoneSnapshot startSnapshot, AzAnimationPoint nextXPoint, AzAnimationPoint nextYPoint, AzAnimationPoint nextZPoint) {
        this.addScaleXPoint(keyframe, lerpedTick, transitionLength, startSnapshot.getScaleX(), nextXPoint.animationStartValue());
        this.addScaleYPoint(keyframe, lerpedTick, transitionLength, startSnapshot.getScaleY(), nextYPoint.animationStartValue());
        this.addScaleZPoint(keyframe, lerpedTick, transitionLength, startSnapshot.getScaleZ(), nextZPoint.animationStartValue());
    }

    public void addRotationXPoint(AzKeyframe<?> keyframe, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.rotationXQueue.add(new AzAnimationPoint(keyframe, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addRotationYPoint(AzKeyframe<?> keyframe, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.rotationYQueue.add(new AzAnimationPoint(keyframe, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addRotationZPoint(AzKeyframe<?> keyframe, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.rotationZQueue.add(new AzAnimationPoint(keyframe, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addNextRotation(AzKeyframe<?> keyframe, double lerpedTick, double transitionLength, AzBoneSnapshot startSnapshot, AzBoneSnapshot initialSnapshot, AzAnimationPoint nextXPoint, AzAnimationPoint nextYPoint, AzAnimationPoint nextZPoint) {
        this.addRotationXPoint(keyframe, lerpedTick, transitionLength, startSnapshot.getRotX() - initialSnapshot.getRotX(), nextXPoint.animationStartValue());
        this.addRotationYPoint(keyframe, lerpedTick, transitionLength, startSnapshot.getRotY() - initialSnapshot.getRotY(), nextYPoint.animationStartValue());
        this.addRotationZPoint(keyframe, lerpedTick, transitionLength, startSnapshot.getRotZ() - initialSnapshot.getRotZ(), nextZPoint.animationStartValue());
    }

    public void addPositions(AzAnimationPoint xPoint, AzAnimationPoint yPoint, AzAnimationPoint zPoint) {
        this.positionXQueue.add(xPoint);
        this.positionYQueue.add(yPoint);
        this.positionZQueue.add(zPoint);
    }

    public void addScales(AzAnimationPoint xPoint, AzAnimationPoint yPoint, AzAnimationPoint zPoint) {
        this.scaleXQueue.add(xPoint);
        this.scaleYQueue.add(yPoint);
        this.scaleZQueue.add(zPoint);
    }

    public void addRotations(AzAnimationPoint xPoint, AzAnimationPoint yPoint, AzAnimationPoint zPoint) {
        this.rotationXQueue.add(xPoint);
        this.rotationYQueue.add(yPoint);
        this.rotationZQueue.add(zPoint);
    }
}

