/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.controller.keyframe;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import mod.azure.azurelib.core.math.IValue;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypes;

public class AzKeyframe<T extends IValue> {
    private final double length;
    private final T startValue;
    private final T endValue;
    private final AzEasingType easingType;
    private final List<T> easingArgs;

    public AzKeyframe(double length, T startValue, T endValue) {
        this(length, startValue, endValue, AzEasingTypes.LINEAR);
    }

    public AzKeyframe(double length, T startValue, T endValue, AzEasingType easingType) {
        this(length, startValue, endValue, easingType, (List<T>)new ObjectArrayList(0));
    }

    public AzKeyframe(double length, T startValue, T endValue, AzEasingType easingType, List<T> easingArgs) {
        this.length = length;
        this.startValue = startValue;
        this.endValue = endValue;
        this.easingType = easingType;
        this.easingArgs = easingArgs;
    }

    public double length() {
        return this.length;
    }

    public T startValue() {
        return this.startValue;
    }

    public T endValue() {
        return this.endValue;
    }

    public AzEasingType easingType() {
        return this.easingType;
    }

    public List<T> easingArgs() {
        return this.easingArgs;
    }

    public String toString() {
        return "AzKeyframe{length=" + this.length + ", startValue=" + this.startValue + ", endValue=" + this.endValue + ", easingType=" + this.easingType + ", easingArgs=" + this.easingArgs + '}';
    }

    public int hashCode() {
        return Objects.hash(this.length, this.startValue, this.endValue, this.easingType, this.easingArgs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AzKeyframe other = (AzKeyframe)obj;
        return Double.compare(this.length, other.length) == 0 && Objects.equals(this.startValue, other.startValue) && Objects.equals(this.endValue, other.endValue) && Objects.equals(this.easingType, other.easingType) && Objects.equals(this.easingArgs, other.easingArgs);
    }
}

