/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.controller.keyframe;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.core.keyframe.event.data.CustomInstructionKeyframeData;
import mod.azure.azurelib.core.keyframe.event.data.KeyFrameData;
import mod.azure.azurelib.core.keyframe.event.data.ParticleKeyframeData;
import mod.azure.azurelib.core.keyframe.event.data.SoundKeyframeData;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.AzKeyframeCallbacks;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.handler.AzCustomKeyframeHandler;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.handler.AzParticleKeyframeHandler;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.handler.AzSoundKeyframeHandler;
import mod.azure.azurelib.rewrite.animation.event.AzCustomInstructionKeyframeEvent;
import mod.azure.azurelib.rewrite.animation.event.AzParticleKeyframeEvent;
import mod.azure.azurelib.rewrite.animation.event.AzSoundKeyframeEvent;
import mod.azure.azurelib.rewrite.animation.primitive.AzQueuedAnimation;

public class AzKeyframeCallbackHandler<T> {
    private final AzAnimationController<T> animationController;
    private final Set<KeyFrameData> executedKeyframes;
    private final AzKeyframeCallbacks<T> keyframeCallbacks;

    public AzKeyframeCallbackHandler(AzAnimationController<T> animationController, AzKeyframeCallbacks<T> keyframeCallbacks) {
        this.animationController = animationController;
        this.executedKeyframes = new ObjectOpenHashSet();
        this.keyframeCallbacks = keyframeCallbacks;
    }

    public void handle(T animatable, double adjustedTick) {
        this.handleSoundKeyframes(animatable, adjustedTick);
        this.handleParticleKeyframes(animatable, adjustedTick);
        this.handleCustomKeyframes(animatable, adjustedTick);
    }

    private void handleCustomKeyframes(T animatable, double adjustedTick) {
        CustomInstructionKeyframeData[] customInstructions;
        AzCustomKeyframeHandler<T> customKeyframeHandler = this.keyframeCallbacks.customKeyframeHandler();
        for (CustomInstructionKeyframeData keyframeData : customInstructions = this.currentAnimation().animation().keyframes().customInstructions()) {
            if (!(adjustedTick >= keyframeData.getStartTick()) || !this.executedKeyframes.add(keyframeData)) continue;
            if (customKeyframeHandler == null) {
                AzureLib.LOGGER.warn("Custom Instruction Keyframe found for {} -> {}, but no keyframe handler registered", (Object)animatable.getClass().getSimpleName(), (Object)this.animationController.name());
                break;
            }
            customKeyframeHandler.handle(new AzCustomInstructionKeyframeEvent<T>(animatable, adjustedTick, this.animationController, keyframeData));
        }
    }

    private void handleParticleKeyframes(T animatable, double adjustedTick) {
        ParticleKeyframeData[] particleInstructions;
        AzParticleKeyframeHandler<T> particleKeyframeHandler = this.keyframeCallbacks.particleKeyframeHandler();
        for (ParticleKeyframeData keyframeData : particleInstructions = this.currentAnimation().animation().keyframes().particles()) {
            if (!(adjustedTick >= keyframeData.getStartTick()) || !this.executedKeyframes.add(keyframeData)) continue;
            if (particleKeyframeHandler == null) {
                AzureLib.LOGGER.warn("Particle Keyframe found for {} -> {}, but no keyframe handler registered", (Object)animatable.getClass().getSimpleName(), (Object)this.animationController.name());
                break;
            }
            particleKeyframeHandler.handle(new AzParticleKeyframeEvent<T>(animatable, adjustedTick, this.animationController, keyframeData));
        }
    }

    private void handleSoundKeyframes(T animatable, double adjustedTick) {
        SoundKeyframeData[] soundInstructions;
        AzSoundKeyframeHandler<T> soundKeyframeHandler = this.keyframeCallbacks.soundKeyframeHandler();
        for (SoundKeyframeData keyframeData : soundInstructions = this.currentAnimation().animation().keyframes().sounds()) {
            if (!(adjustedTick >= keyframeData.getStartTick()) || !this.executedKeyframes.add(keyframeData)) continue;
            if (soundKeyframeHandler == null) {
                AzureLib.LOGGER.warn("Sound Keyframe found for {} -> {}, but no keyframe handler registered", (Object)animatable.getClass().getSimpleName(), (Object)this.animationController.name());
                break;
            }
            soundKeyframeHandler.handle(new AzSoundKeyframeEvent<T>(animatable, adjustedTick, this.animationController, keyframeData));
        }
    }

    public void reset() {
        this.executedKeyframes.clear();
    }

    private AzQueuedAnimation currentAnimation() {
        return this.animationController.currentAnimation();
    }
}

