/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.controller.keyframe;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.AzKeyframe;

public class AzKeyframeStack<T extends AzKeyframe<?>> {
    private final List<T> xKeyframes;
    private final List<T> yKeyframes;
    private final List<T> zKeyframes;

    public AzKeyframeStack() {
        this((List<T>)new ObjectArrayList(), (List<T>)new ObjectArrayList(), (List<T>)new ObjectArrayList());
    }

    public AzKeyframeStack(List<T> xKeyframes, List<T> yKeyframes, List<T> zKeyframes) {
        this.xKeyframes = xKeyframes;
        this.yKeyframes = yKeyframes;
        this.zKeyframes = zKeyframes;
    }

    public static <F extends AzKeyframe<?>> AzKeyframeStack<F> from(AzKeyframeStack<F> otherStack) {
        return new AzKeyframeStack<F>(otherStack.xKeyframes(), otherStack.yKeyframes(), otherStack.zKeyframes());
    }

    public double getLastKeyframeTime() {
        double xTime = 0.0;
        double yTime = 0.0;
        double zTime = 0.0;
        for (AzKeyframe frame : this.xKeyframes()) {
            xTime += frame.length();
        }
        for (AzKeyframe frame : this.yKeyframes()) {
            yTime += frame.length();
        }
        for (AzKeyframe frame : this.zKeyframes()) {
            zTime += frame.length();
        }
        return Math.max(xTime, Math.max(yTime, zTime));
    }

    public List<T> xKeyframes() {
        return this.xKeyframes;
    }

    public List<T> yKeyframes() {
        return this.yKeyframes;
    }

    public List<T> zKeyframes() {
        return this.zKeyframes;
    }

    public String toString() {
        return "AzKeyframeStack{xKeyframes=" + this.xKeyframes + ", yKeyframes=" + this.yKeyframes + ", zKeyframes=" + this.zKeyframes + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AzKeyframeStack that = (AzKeyframeStack)obj;
        if (!this.xKeyframes.equals(that.xKeyframes)) {
            return false;
        }
        if (!this.yKeyframes.equals(that.yKeyframes)) {
            return false;
        }
        return this.zKeyframes.equals(that.zKeyframes);
    }

    public int hashCode() {
        int result = this.xKeyframes.hashCode();
        result = 31 * result + this.yKeyframes.hashCode();
        result = 31 * result + this.zKeyframes.hashCode();
        return result;
    }
}

