/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.dispatch.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.network.AzureLibNetwork;
import mod.azure.azurelib.network.packet.AzBlockEntityDispatchCommandPacket;
import mod.azure.azurelib.network.packet.AzEntityDispatchCommandPacket;
import mod.azure.azurelib.network.packet.AzItemStackDispatchCommandPacket;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorAccessor;
import mod.azure.azurelib.rewrite.animation.cache.AzIdentityRegistry;
import mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.rewrite.animation.dispatch.command.AzRootCommandBuilder;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.AzAction;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehaviors;
import mod.azure.azurelib.rewrite.util.codec.AzListStreamCodec;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.PacketDistributor;

public class AzCommand {
    private List<AzAction> actions;
    public static final AzListStreamCodec<AzAction> ACTION_LIST_CODEC = new AzListStreamCodec<AzAction>(AzAction::decode, (buf, action) -> action.encode((PacketBuffer)buf));
    public static final Function<PacketBuffer, AzCommand> DECODER = buf -> {
        List<AzAction> actions = ACTION_LIST_CODEC.decode((PacketBuffer)buf);
        return new AzCommand(actions);
    };
    public static final BiConsumer<PacketBuffer, AzCommand> ENCODER = (buf, command) -> ACTION_LIST_CODEC.encode((PacketBuffer)buf, command.actions());

    public AzCommand(List<AzAction> actions) {
        this.actions = actions;
    }

    public List<AzAction> actions() {
        return this.actions;
    }

    public static AzRootCommandBuilder builder() {
        return new AzRootCommandBuilder();
    }

    public static AzCommand compose(Collection<AzCommand> commands) {
        if (commands.isEmpty()) {
            throw new IllegalArgumentException("Attempted to compose an empty collection of commands.");
        }
        if (commands.size() == 1) {
            return commands.iterator().next();
        }
        return new AzCommand(commands.stream().flatMap(command -> command.actions().stream()).collect(Collectors.toList()));
    }

    public static AzCommand compose(AzCommand first, AzCommand second, AzCommand ... others) {
        ArrayList<AzCommand> allCommands = new ArrayList<AzCommand>();
        allCommands.add(first);
        allCommands.add(second);
        Collections.addAll(allCommands, others);
        return AzCommand.compose(allCommands);
    }

    public static AzCommand create(String controllerName, String animationName) {
        return AzCommand.create(controllerName, animationName, AzPlayBehaviors.PLAY_ONCE);
    }

    public static AzCommand create(String controllerName, String animationName, AzPlayBehavior playBehavior) {
        return AzCommand.builder().playSequence(controllerName, sequenceBuilder -> sequenceBuilder.queue(animationName, props -> props.withPlayBehavior(playBehavior))).build();
    }

    public void sendForEntity(Entity entity) {
        if (entity.field_70170_p.func_201670_d()) {
            this.dispatchFromClient(entity);
        } else {
            int entityId = entity.func_145782_y();
            AzEntityDispatchCommandPacket packet = new AzEntityDispatchCommandPacket(entityId, this);
            AzureLibNetwork.send(packet, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity));
        }
    }

    public void sendForBlockEntity(TileEntity entity) {
        if (entity.func_145831_w().func_201670_d()) {
            this.dispatchFromClient(entity);
        } else {
            BlockPos entityBlockPos = entity.func_174877_v();
            AzBlockEntityDispatchCommandPacket packet = new AzBlockEntityDispatchCommandPacket(entityBlockPos, this);
            AzureLibNetwork.send(packet, PacketDistributor.TRACKING_CHUNK.with(() -> entity.func_145831_w().func_175726_f(entityBlockPos)));
        }
    }

    public void sendForItem(Entity entity, ItemStack itemStack) {
        if (entity.field_70170_p.func_201670_d()) {
            this.dispatchFromClient(entity);
        } else {
            if (!AzIdentityRegistry.hasIdentity(itemStack.func_77973_b())) {
                return;
            }
            UUID uuid = itemStack.func_77978_p().func_186857_a("az_id");
            if (uuid == null) {
                AzureLib.LOGGER.warn("Could not find item stack UUID during dispatch. Did you forget to register an identity for the item? Item: {}, Item Stack: {}", (Object)itemStack.func_77973_b(), (Object)itemStack);
                return;
            }
            AzItemStackDispatchCommandPacket packet = new AzItemStackDispatchCommandPacket(uuid, this);
            AzureLibNetwork.send(packet, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity));
        }
    }

    private <T> void dispatchFromClient(T animatable) {
        AzAnimator animator = AzAnimatorAccessor.getOrNull(animatable);
        if (animator != null) {
            this.actions.forEach(action -> action.handle(AzDispatchSide.CLIENT, animator));
        }
    }
}

