/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.dispatch.command.action.codec;

import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.AzAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.registry.AzActionRegistry;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class AzActionCodec {
    public AzAction decode(PacketBuffer byteBuf) {
        short id = byteBuf.readShort();
        Function<PacketBuffer, AzAction> codec = AzActionRegistry.getDecoderOrNull(id);
        if (codec == null) {
            throw new NullPointerException("Could not find action decoder for a given action ID while decoding data. ID: " + id);
        }
        return codec.apply(byteBuf);
    }

    public void encode(PacketBuffer byteBuf, AzAction action) {
        ResourceLocation resourceLocation = action.getResourceLocation();
        Short id = AzActionRegistry.getIdOrNull(resourceLocation);
        BiConsumer<PacketBuffer, AzAction> encoder = AzActionRegistry.getEncoderOrNull(resourceLocation);
        if (id == null) {
            throw new NullPointerException("Could not find action ID for a given resource location while encoding data. Resource Location: " + resourceLocation);
        }
        byteBuf.writeShort((int)id.shortValue());
        if (encoder == null) {
            throw new NullPointerException("Could not find action encoder for a given resource location while encoding data. Resource Location: " + resourceLocation + ", ID: " + id);
        }
        encoder.accept(byteBuf, action);
    }
}

