/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.root;

import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.AzAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.sequence.AzAnimationSequence;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class AzRootPlayAnimationSequenceAction
implements AzAction {
    private final String controllerName;
    private final AzAnimationSequence sequence;
    public static final Function<PacketBuffer, AzRootPlayAnimationSequenceAction> DECODER = buf -> {
        String controllerName = buf.func_218666_n();
        AzAnimationSequence sequence = AzAnimationSequence.DECODER.apply((PacketBuffer)buf);
        return new AzRootPlayAnimationSequenceAction(controllerName, sequence);
    };
    public static final BiConsumer<PacketBuffer, AzRootPlayAnimationSequenceAction> ENCODER = (buf, action) -> {
        buf.func_180714_a(action.controllerName());
        AzAnimationSequence.ENCODER.accept((PacketBuffer)buf, action.sequence());
    };
    public static final ResourceLocation RESOURCE_LOCATION = AzureLib.modResource("root/play_animation_sequence");

    public AzRootPlayAnimationSequenceAction(String controllerName, AzAnimationSequence sequence) {
        this.controllerName = controllerName;
        this.sequence = sequence;
    }

    public String controllerName() {
        return this.controllerName;
    }

    public AzAnimationSequence sequence() {
        return this.sequence;
    }

    @Override
    public void handle(AzDispatchSide originSide, AzAnimator<?> animator) {
        AzAnimationController<?> controller = animator.getAnimationControllerContainer().getOrNull(this.controllerName);
        if (controller != null) {
            controller.run(originSide, this.sequence);
        }
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return RESOURCE_LOCATION;
    }

    public static AzRootPlayAnimationSequenceAction decode(PacketBuffer buf) {
        return DECODER.apply(buf);
    }

    public static void encode(PacketBuffer buf, AzRootPlayAnimationSequenceAction action) {
        ENCODER.accept(buf, action);
    }

    public String toString() {
        return "AzRootPlayAnimationSequenceAction{controllerName='" + this.controllerName + '\'' + ", sequence=" + this.sequence + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzRootPlayAnimationSequenceAction that = (AzRootPlayAnimationSequenceAction)o;
        if (!this.controllerName.equals(that.controllerName)) {
            return false;
        }
        return this.sequence.equals(that.sequence);
    }

    public int hashCode() {
        int result = this.controllerName.hashCode();
        result = 31 * result + this.sequence.hashCode();
        return result;
    }
}

