/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.root;

import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.AzAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class AzRootSetAnimationSpeedAction
implements AzAction {
    private final double animationSpeed;
    public static final Function<PacketBuffer, AzRootSetAnimationSpeedAction> DECODER = buf -> {
        double animationSpeed = buf.readDouble();
        return new AzRootSetAnimationSpeedAction(animationSpeed);
    };
    public static final BiConsumer<PacketBuffer, AzRootSetAnimationSpeedAction> ENCODER = (buf, action) -> buf.writeDouble(action.animationSpeed());
    public static final ResourceLocation RESOURCE_LOCATION = AzureLib.modResource("root/set_animation_speed");

    public AzRootSetAnimationSpeedAction(double animationSpeed) {
        this.animationSpeed = animationSpeed;
    }

    public double animationSpeed() {
        return this.animationSpeed;
    }

    @Override
    public void handle(AzDispatchSide originSide, AzAnimator<?> animator) {
        animator.getAnimationControllerContainer().getAll().forEach(controller -> controller.setAnimationProperties(controller.animationProperties().withAnimationSpeed(this.animationSpeed)));
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return RESOURCE_LOCATION;
    }

    public static AzRootSetAnimationSpeedAction decode(PacketBuffer buf) {
        return DECODER.apply(buf);
    }

    public static void encode(PacketBuffer buf, AzRootSetAnimationSpeedAction action) {
        ENCODER.accept(buf, action);
    }

    public String toString() {
        return "AzRootSetAnimationSpeedAction{animationSpeed=" + this.animationSpeed + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzRootSetAnimationSpeedAction that = (AzRootSetAnimationSpeedAction)o;
        return Double.compare(that.animationSpeed, this.animationSpeed) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.animationSpeed);
        return (int)(temp ^ temp >>> 32);
    }
}

