/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.root;

import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.AzAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class AzRootSetTransitionSpeedAction
implements AzAction {
    private final float transitionSpeed;
    public static final Function<PacketBuffer, AzRootSetTransitionSpeedAction> DECODER = buf -> {
        float transitionSpeed = buf.readFloat();
        return new AzRootSetTransitionSpeedAction(transitionSpeed);
    };
    public static final BiConsumer<PacketBuffer, AzRootSetTransitionSpeedAction> ENCODER = (buf, action) -> buf.writeFloat(action.transitionSpeed());
    public static final ResourceLocation RESOURCE_LOCATION = AzureLib.modResource("root/set_transition_speed");

    public AzRootSetTransitionSpeedAction(float transitionSpeed) {
        this.transitionSpeed = transitionSpeed;
    }

    public float transitionSpeed() {
        return this.transitionSpeed;
    }

    @Override
    public void handle(AzDispatchSide originSide, AzAnimator<?> animator) {
        animator.getAnimationControllerContainer().getAll().forEach(controller -> controller.setAnimationProperties(controller.animationProperties().withTransitionLength(this.transitionSpeed)));
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return RESOURCE_LOCATION;
    }

    public static AzRootSetTransitionSpeedAction decode(PacketBuffer buf) {
        return DECODER.apply(buf);
    }

    public static void encode(PacketBuffer buf, AzRootSetTransitionSpeedAction action) {
        ENCODER.accept(buf, action);
    }

    public String toString() {
        return "AzRootSetTransitionSpeedAction{transitionSpeed=" + this.transitionSpeed + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzRootSetTransitionSpeedAction that = (AzRootSetTransitionSpeedAction)o;
        return Float.compare(that.transitionSpeed, this.transitionSpeed) == 0;
    }

    public int hashCode() {
        return Float.hashCode(this.transitionSpeed);
    }
}

