/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.primitive;

import java.util.Map;
import mod.azure.azurelib.AzureLibException;
import mod.azure.azurelib.rewrite.animation.cache.AzBakedAnimationCache;
import mod.azure.azurelib.rewrite.animation.primitive.AzBakedAnimation;
import net.minecraft.util.ResourceLocation;

public class AzBakedAnimations {
    private final Map<String, AzBakedAnimation> animations;
    private final Map<String, ResourceLocation> includes;

    public AzBakedAnimations(Map<String, AzBakedAnimation> animations, Map<String, ResourceLocation> includes) {
        this.animations = animations;
        this.includes = includes;
    }

    public Map<String, AzBakedAnimation> animations() {
        return this.animations;
    }

    public Map<String, ResourceLocation> includes() {
        return this.includes;
    }

    public AzBakedAnimation getAnimation(String name) {
        ResourceLocation otherFileID;
        AzBakedAnimation result = this.animations.get(name);
        if (result == null && this.includes != null && (otherFileID = (ResourceLocation)this.includes.getOrDefault(name, null)) != null) {
            AzBakedAnimations otherBakedAnims = AzBakedAnimationCache.getInstance().getNullable(otherFileID);
            if (otherBakedAnims.equals(this)) {
                throw new AzureLibException("The animation file '" + otherFileID + "' refers back to itself through includes.");
            }
            result = otherBakedAnims.getAnimationWithoutIncludes(name);
        }
        return result;
    }

    private AzBakedAnimation getAnimationWithoutIncludes(String name) {
        return this.animations.get(name);
    }

    public String toString() {
        return "AzBakedAnimations{animations=" + this.animations + ", includes=" + this.includes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzBakedAnimations that = (AzBakedAnimations)o;
        if (!this.animations.equals(that.animations)) {
            return false;
        }
        return this.includes.equals(that.includes);
    }

    public int hashCode() {
        int result = this.animations.hashCode();
        result = 31 * result + this.includes.hashCode();
        return result;
    }
}

