/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.property;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypes;
import mod.azure.azurelib.rewrite.animation.property.codec.AzAnimationPropertiesCodec;
import net.minecraft.network.PacketBuffer;

public class AzAnimationProperties {
    public static final Function<PacketBuffer, AzAnimationProperties> DECODER = AzAnimationPropertiesCodec.DECODER;
    public static final BiConsumer<PacketBuffer, AzAnimationProperties> ENCODER = AzAnimationPropertiesCodec.ENCODER;
    public static final AzAnimationProperties DEFAULT = new AzAnimationProperties(1.0, AzEasingTypes.NONE, Float.valueOf(0.0f));
    public static final AzAnimationProperties EMPTY = new AzAnimationProperties(null, null, null);
    protected final Double animationSpeed;
    protected final AzEasingType easingType;
    protected final Float transitionLength;

    public AzAnimationProperties(Double animationSpeed, AzEasingType easingType, Float transitionLength) {
        this.animationSpeed = animationSpeed;
        this.easingType = easingType;
        this.transitionLength = transitionLength;
    }

    public boolean hasAnimationSpeed() {
        return this.animationSpeed != null;
    }

    public boolean hasEasingType() {
        return this.easingType != null;
    }

    public boolean hasTransitionLength() {
        return this.transitionLength != null;
    }

    public AzAnimationProperties withAnimationSpeed(double animationSpeed) {
        return new AzAnimationProperties(animationSpeed, this.easingType, this.transitionLength);
    }

    public AzAnimationProperties withEasingType(AzEasingType easingType) {
        return new AzAnimationProperties(this.animationSpeed, easingType, this.transitionLength);
    }

    public AzAnimationProperties withTransitionLength(float transitionLength) {
        return new AzAnimationProperties(this.animationSpeed, this.easingType, Float.valueOf(transitionLength));
    }

    public double animationSpeed() {
        return this.animationSpeed == null ? DEFAULT.animationSpeed() : this.animationSpeed.doubleValue();
    }

    public AzEasingType easingType() {
        return this.easingType == null ? DEFAULT.easingType() : this.easingType;
    }

    public float transitionLength() {
        return this.transitionLength == null ? DEFAULT.transitionLength() : this.transitionLength.floatValue();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AzAnimationProperties that = (AzAnimationProperties)object;
        return Objects.equals(this.animationSpeed, that.animationSpeed) && Objects.equals(this.easingType, that.easingType) && Objects.equals(this.transitionLength, that.transitionLength);
    }

    public int hashCode() {
        return Objects.hash(this.animationSpeed, this.easingType, this.transitionLength);
    }
}

