/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.model;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import mod.azure.azurelib.core.state.BoneSnapshot;
import mod.azure.azurelib.rewrite.model.AzBoneMetadata;
import mod.azure.azurelib.rewrite.model.AzBoneSnapshot;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;

public class AzBone
implements CoreGeoBone {
    private final AzBoneMetadata metadata;
    private final List<AzBone> children = new ObjectArrayList();
    private final List<GeoCube> cubes = new ObjectArrayList();
    private final Matrix4f modelSpaceMatrix = new Matrix4f();
    private final Matrix4f localSpaceMatrix = new Matrix4f();
    private final Matrix4f worldSpaceMatrix = new Matrix4f();
    private AzBoneSnapshot initialSnapshot;
    private boolean hidden;
    private boolean childrenHidden = false;
    private final Vector3f pivot;
    private final Vector3f position;
    private final Vector3f rotation;
    private final Vector3f scale;
    private boolean positionChanged = false;
    private boolean rotationChanged = false;
    private boolean scaleChanged = false;
    private Matrix3f worldSpaceNormal = new Matrix3f();
    private boolean trackingMatrices;

    public AzBone(AzBoneMetadata metadata) {
        this.metadata = metadata;
        this.trackingMatrices = false;
        this.hidden = metadata.getDontRender() == Boolean.TRUE;
        this.position = new Vector3f();
        this.pivot = new Vector3f();
        this.rotation = new Vector3f();
        this.scale = new Vector3f(1.0f, 1.0f, 1.0f);
        this.worldSpaceNormal.func_226119_c_();
        this.worldSpaceMatrix.func_226591_a_();
        this.localSpaceMatrix.func_226591_a_();
        this.modelSpaceMatrix.func_226591_a_();
    }

    @Override
    public String getName() {
        return this.metadata.getName();
    }

    @Override
    public AzBone getParent() {
        return this.metadata.getParent();
    }

    @Override
    public float getRotX() {
        return this.rotation.func_195899_a();
    }

    @Override
    public void setRotX(float value) {
        this.rotation.setX(value);
        this.markRotationAsChanged();
    }

    @Override
    public float getRotY() {
        return this.rotation.func_195900_b();
    }

    @Override
    public void setRotY(float value) {
        this.rotation.setY(value);
        this.markRotationAsChanged();
    }

    @Override
    public float getRotZ() {
        return this.rotation.func_195902_c();
    }

    @Override
    public void setRotZ(float value) {
        this.rotation.setZ(value);
        this.markRotationAsChanged();
    }

    @Override
    public float getPosX() {
        return this.position.func_195899_a();
    }

    @Override
    public void setPosX(float value) {
        this.position.setX(value);
        this.markPositionAsChanged();
    }

    @Override
    public float getPosY() {
        return this.position.func_195900_b();
    }

    @Override
    public void setPosY(float value) {
        this.position.setY(value);
        this.markPositionAsChanged();
    }

    @Override
    public float getPosZ() {
        return this.position.func_195902_c();
    }

    @Override
    public void setPosZ(float value) {
        this.position.setZ(value);
        this.markPositionAsChanged();
    }

    @Override
    public float getScaleX() {
        return this.scale.func_195899_a();
    }

    @Override
    public void setScaleX(float value) {
        this.scale.setX(value);
        this.markScaleAsChanged();
    }

    @Override
    public float getScaleY() {
        return this.scale.func_195900_b();
    }

    @Override
    public void setScaleY(float value) {
        this.scale.setY(value);
        this.markScaleAsChanged();
    }

    @Override
    public float getScaleZ() {
        return this.scale.func_195902_c();
    }

    @Override
    public void setScaleZ(float value) {
        this.scale.setZ(value);
        this.markScaleAsChanged();
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        this.setChildrenHidden(hidden);
    }

    @Override
    public void setChildrenHidden(boolean hideChildren) {
        this.childrenHidden = hideChildren;
    }

    @Override
    public float getPivotX() {
        return this.pivot.func_195899_a();
    }

    @Override
    public void setPivotX(float value) {
        this.pivot.setX(value);
    }

    @Override
    public float getPivotY() {
        return this.pivot.func_195900_b();
    }

    @Override
    public void setPivotY(float value) {
        this.pivot.setY(value);
    }

    @Override
    public float getPivotZ() {
        return this.pivot.func_195902_c();
    }

    @Override
    public void setPivotZ(float value) {
        this.pivot.setZ(value);
    }

    @Override
    public boolean isHidingChildren() {
        return this.childrenHidden;
    }

    @Override
    public void markScaleAsChanged() {
        this.scaleChanged = true;
    }

    @Override
    public void markRotationAsChanged() {
        this.rotationChanged = true;
    }

    @Override
    public void markPositionAsChanged() {
        this.positionChanged = true;
    }

    @Override
    public boolean hasScaleChanged() {
        return this.scaleChanged;
    }

    @Override
    public boolean hasRotationChanged() {
        return this.rotationChanged;
    }

    @Override
    public boolean hasPositionChanged() {
        return this.positionChanged;
    }

    @Override
    public void resetStateChanges() {
        this.scaleChanged = false;
        this.rotationChanged = false;
        this.positionChanged = false;
    }

    @Override
    public BoneSnapshot getInitialSnapshot() {
        throw new UnsupportedOperationException();
    }

    public AzBoneSnapshot getInitialAzSnapshot() {
        return this.initialSnapshot;
    }

    public List<AzBone> getChildBones() {
        return this.children;
    }

    @Override
    public void saveInitialSnapshot() {
        if (this.initialSnapshot == null) {
            this.initialSnapshot = new AzBoneSnapshot(this);
        }
    }

    public Boolean getMirror() {
        return this.metadata.getMirror();
    }

    public Double getInflate() {
        return this.metadata.getInflate();
    }

    public Boolean shouldNeverRender() {
        return this.metadata.getDontRender();
    }

    public Boolean getReset() {
        return this.metadata.getReset();
    }

    public List<GeoCube> getCubes() {
        return this.cubes;
    }

    public boolean isTrackingMatrices() {
        return this.trackingMatrices;
    }

    public void setTrackingMatrices(boolean trackingMatrices) {
        this.trackingMatrices = trackingMatrices;
    }

    public Matrix4f getModelSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.modelSpaceMatrix;
    }

    public void setModelSpaceMatrix(Matrix4f matrix) {
        this.modelSpaceMatrix.set(matrix);
    }

    public Matrix4f getLocalSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.localSpaceMatrix;
    }

    public void setLocalSpaceMatrix(Matrix4f matrix) {
        RenderUtils.copy(this.localSpaceMatrix, matrix);
    }

    public Matrix4f getWorldSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.worldSpaceMatrix;
    }

    public void setWorldSpaceMatrix(Matrix4f matrix) {
        this.worldSpaceMatrix.set(matrix);
    }

    public Matrix3f getWorldSpaceNormal() {
        return this.worldSpaceNormal;
    }

    public void setWorldSpaceNormal(Matrix3f matrix) {
        this.worldSpaceNormal = matrix;
    }

    public Vector3d getLocalPosition() {
        Matrix4f matrix = this.getLocalSpaceMatrix();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.func_229372_a_(matrix);
        return new Vector3d((double)vec.func_195910_a(), (double)vec.func_195913_b(), (double)vec.func_195914_c());
    }

    public Vector3d getModelPosition() {
        Matrix4f matrix = this.getModelSpaceMatrix();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.func_229372_a_(matrix);
        return new Vector3d((double)(-vec.func_195910_a() * 16.0f), (double)(vec.func_195913_b() * 16.0f), (double)(vec.func_195914_c() * 16.0f));
    }

    public void setModelPosition(Vector3d pos) {
        AzBone parent = this.getParent();
        Matrix4f identity = new Matrix4f();
        identity.func_226591_a_();
        Matrix4f matrix = parent == null ? identity : parent.getModelSpaceMatrix().func_226601_d_();
        matrix.func_226600_c_();
        Vector4f vec = new Vector4f(-((float)pos.field_181059_a) / 16.0f, (float)pos.field_181060_b / 16.0f, (float)pos.field_181061_c / 16.0f, 1.0f);
        vec.func_229372_a_(matrix);
        this.updatePosition(-vec.func_195910_a() * 16.0f, vec.func_195913_b() * 16.0f, vec.func_195914_c() * 16.0f);
    }

    public Vector3d getWorldPosition() {
        Matrix4f matrix = this.getWorldSpaceMatrix();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.func_229372_a_(matrix);
        return new Vector3d((double)vec.func_195910_a(), (double)vec.func_195913_b(), (double)vec.func_195914_c());
    }

    public Matrix4f getModelRotationMatrix() {
        Matrix4f matrix = this.getModelSpaceMatrix().func_226601_d_();
        AzBone.removeMatrixTranslation(matrix);
        return matrix;
    }

    public static void removeMatrixTranslation(Matrix4f matrix) {
        matrix.field_226578_d_ = 0.0f;
        matrix.field_226582_h_ = 0.0f;
        matrix.field_226586_l_ = 0.0f;
    }

    public Vector3d getPositionVector() {
        return new Vector3d((double)this.getPosX(), (double)this.getPosY(), (double)this.getPosZ());
    }

    public Vector3d getRotationVector() {
        return new Vector3d((double)this.getRotX(), (double)this.getRotY(), (double)this.getRotZ());
    }

    public Vector3d getScaleVector() {
        return new Vector3d((double)this.getScaleX(), (double)this.getScaleY(), (double)this.getScaleZ());
    }

    public void addRotationOffsetFromBone(AzBone source) {
        this.setRotX(this.getRotX() + source.getRotX() - source.getInitialAzSnapshot().getRotX());
        this.setRotY(this.getRotY() + source.getRotY() - source.getInitialAzSnapshot().getRotY());
        this.setRotZ(this.getRotZ() + source.getRotZ() - source.getInitialAzSnapshot().getRotZ());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getParent() != null ? this.getParent().getName() : Integer.valueOf(0), this.getCubes().size(), this.getChildBones().size());
    }
}

