/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.model;

import mod.azure.azurelib.rewrite.model.AzBone;
import net.minecraft.client.renderer.Vector3f;

public class AzBoneSnapshot {
    private final AzBone bone;
    private final Vector3f offsetPosition;
    private final Vector3f rotation;
    private final Vector3f scale;
    private double lastResetRotationTick = 0.0;
    private double lastResetPositionTick = 0.0;
    private double lastResetScaleTick = 0.0;
    private boolean rotAnimInProgress = true;
    private boolean posAnimInProgress = true;
    private boolean scaleAnimInProgress = true;

    public AzBoneSnapshot(AzBone bone) {
        this.bone = bone;
        this.offsetPosition = new Vector3f(bone.getPosX(), bone.getPosY(), bone.getPosZ());
        this.rotation = new Vector3f(bone.getRotX(), bone.getRotY(), bone.getRotZ());
        this.scale = new Vector3f(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static AzBoneSnapshot copy(AzBoneSnapshot snapshot) {
        AzBoneSnapshot newSnapshot = new AzBoneSnapshot(snapshot.bone);
        newSnapshot.offsetPosition.func_195905_a(snapshot.offsetPosition.func_195899_a(), snapshot.offsetPosition.func_195900_b(), snapshot.offsetPosition.func_195902_c());
        newSnapshot.rotation.func_195905_a(snapshot.rotation.func_195899_a(), snapshot.rotation.func_195900_b(), snapshot.rotation.func_195902_c());
        newSnapshot.scale.func_195905_a(snapshot.scale.func_195899_a(), snapshot.scale.func_195900_b(), snapshot.scale.func_195902_c());
        return newSnapshot;
    }

    public AzBone getBone() {
        return this.bone;
    }

    public float getScaleX() {
        return this.scale.func_195899_a();
    }

    public float getScaleY() {
        return this.scale.func_195900_b();
    }

    public float getScaleZ() {
        return this.scale.func_195902_c();
    }

    public float getOffsetX() {
        return this.offsetPosition.func_195899_a();
    }

    public float getOffsetY() {
        return this.offsetPosition.func_195900_b();
    }

    public float getOffsetZ() {
        return this.offsetPosition.func_195902_c();
    }

    public float getRotX() {
        return this.rotation.func_195899_a();
    }

    public float getRotY() {
        return this.rotation.func_195900_b();
    }

    public float getRotZ() {
        return this.rotation.func_195902_c();
    }

    public double getLastResetRotationTick() {
        return this.lastResetRotationTick;
    }

    public double getLastResetPositionTick() {
        return this.lastResetPositionTick;
    }

    public double getLastResetScaleTick() {
        return this.lastResetScaleTick;
    }

    public boolean isRotAnimInProgress() {
        return this.rotAnimInProgress;
    }

    public boolean isPosAnimInProgress() {
        return this.posAnimInProgress;
    }

    public boolean isScaleAnimInProgress() {
        return this.scaleAnimInProgress;
    }

    public void updateScale(float scaleX, float scaleY, float scaleZ) {
        this.scale.func_195905_a(scaleX, scaleY, scaleZ);
    }

    public void updateOffset(float offsetX, float offsetY, float offsetZ) {
        this.offsetPosition.func_195905_a(offsetX, offsetY, offsetZ);
    }

    public void updateRotation(float rotX, float rotY, float rotZ) {
        this.rotation.func_195905_a(rotX, rotY, rotZ);
    }

    public void startPosAnim() {
        this.posAnimInProgress = true;
    }

    public void stopPosAnim(double tick) {
        this.posAnimInProgress = false;
        this.lastResetPositionTick = tick;
    }

    public void startRotAnim() {
        this.rotAnimInProgress = true;
    }

    public void stopRotAnim(double tick) {
        this.rotAnimInProgress = false;
        this.lastResetRotationTick = tick;
    }

    public void startScaleAnim() {
        this.scaleAnimInProgress = true;
    }

    public void stopScaleAnim(double tick) {
        this.scaleAnimInProgress = false;
        this.lastResetScaleTick = tick;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return this.bone.getName().hashCode();
    }
}

