/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.model.factory;

import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.cache.object.GeoQuad;
import mod.azure.azurelib.loading.json.raw.Cube;
import mod.azure.azurelib.loading.json.raw.FaceUV;
import mod.azure.azurelib.loading.json.raw.ModelProperties;
import mod.azure.azurelib.loading.json.raw.UVUnion;
import mod.azure.azurelib.loading.object.BoneStructure;
import mod.azure.azurelib.loading.object.GeometryTree;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.model.factory.primitive.VertexSet;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.util.Direction;

public abstract class AzBakedModelFactory {
    public abstract AzBakedModel constructGeoModel(GeometryTree var1);

    public abstract AzBone constructBone(BoneStructure var1, ModelProperties var2, AzBone var3);

    public abstract GeoCube constructCube(Cube var1, ModelProperties var2, AzBone var3);

    public GeoQuad[] buildQuads(UVUnion uvUnion, VertexSet vertices, Cube cube, float textureWidth, float textureHeight, boolean mirror) {
        GeoQuad[] quads = new GeoQuad[]{this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.WEST), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.EAST), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.NORTH), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.SOUTH), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.UP), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.DOWN)};
        return quads;
    }

    public GeoQuad buildQuad(VertexSet vertices, Cube cube, UVUnion uvUnion, float textureWidth, float textureHeight, boolean mirror, Direction direction) {
        if (!uvUnion.isBoxUV()) {
            FaceUV faceUV = uvUnion.faceUV().fromDirection(direction);
            if (faceUV == null) {
                return null;
            }
            return GeoQuad.build(vertices.verticesForQuad(direction, false, mirror || cube.mirror() == Boolean.TRUE), faceUV.getUv(), faceUV.getUvSize(), faceUV.getUvRotation(), textureWidth, textureHeight, mirror, direction);
        }
        double[] uv = cube.uv().boxUVCoords();
        double[] uvSize = cube.size();
        Vector3d uvSizeVec = new Vector3d(Math.floor(uvSize[0]), Math.floor(uvSize[1]), Math.floor(uvSize[2]));
        Object uvData = null;
        switch (direction) {
            case WEST: {
                uvData = new double[][]{{uv[0] + uvSizeVec.field_181061_c + uvSizeVec.field_181059_a, uv[1] + uvSizeVec.field_181061_c}, {uvSizeVec.field_181061_c, uvSizeVec.field_181060_b}};
                break;
            }
            case EAST: {
                uvData = new double[][]{{uv[0], uv[1] + uvSizeVec.field_181061_c}, {uvSizeVec.field_181061_c, uvSizeVec.field_181060_b}};
                break;
            }
            case NORTH: {
                uvData = new double[][]{{uv[0] + uvSizeVec.field_181061_c, uv[1] + uvSizeVec.field_181061_c}, {uvSizeVec.field_181059_a, uvSizeVec.field_181060_b}};
                break;
            }
            case SOUTH: {
                uvData = new double[][]{{uv[0] + uvSizeVec.field_181061_c + uvSizeVec.field_181059_a + uvSizeVec.field_181061_c, uv[1] + uvSizeVec.field_181061_c}, {uvSizeVec.field_181059_a, uvSizeVec.field_181060_b}};
                break;
            }
            case UP: {
                uvData = new double[][]{{uv[0] + uvSizeVec.field_181061_c, uv[1]}, {uvSizeVec.field_181059_a, uvSizeVec.field_181061_c}};
                break;
            }
            case DOWN: {
                uvData = new double[][]{{uv[0] + uvSizeVec.field_181061_c + uvSizeVec.field_181059_a, uv[1] + uvSizeVec.field_181061_c}, {uvSizeVec.field_181059_a, -uvSizeVec.field_181061_c}};
            }
        }
        return GeoQuad.build(vertices.verticesForQuad(direction, true, mirror || cube.mirror() == Boolean.TRUE), uvData[0], uvData[1], FaceUV.Rotation.NONE, textureWidth, textureHeight, mirror, direction);
    }
}

