/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.model.factory.impl;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.cache.object.GeoQuad;
import mod.azure.azurelib.loading.json.raw.Bone;
import mod.azure.azurelib.loading.json.raw.Cube;
import mod.azure.azurelib.loading.json.raw.ModelProperties;
import mod.azure.azurelib.loading.object.BoneStructure;
import mod.azure.azurelib.loading.object.GeometryTree;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.model.AzBoneMetadata;
import mod.azure.azurelib.rewrite.model.factory.AzBakedModelFactory;
import mod.azure.azurelib.rewrite.model.factory.primitive.VertexSet;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.util.math.Vec3d;

public final class AzBuiltinBakedModelFactory
extends AzBakedModelFactory {
    @Override
    public AzBakedModel constructGeoModel(GeometryTree geometryTree) {
        ObjectArrayList bones = new ObjectArrayList();
        for (BoneStructure boneStructure : geometryTree.topLevelBones().values()) {
            bones.add((Object)this.constructBone(boneStructure, geometryTree.properties(), null));
        }
        return new AzBakedModel((List<AzBone>)bones);
    }

    @Override
    public AzBone constructBone(BoneStructure boneStructure, ModelProperties properties, AzBone parent) {
        Bone bone = boneStructure.self();
        AzBoneMetadata boneMetadata = new AzBoneMetadata(bone, parent);
        AzBone newBone = new AzBone(boneMetadata);
        Vec3d rotation = RenderUtils.arrayToVec(bone.rotation());
        Vec3d pivot = RenderUtils.arrayToVec(bone.pivot());
        newBone.updateRotation((float)Math.toRadians(-rotation.field_72450_a), (float)Math.toRadians(-rotation.field_72448_b), (float)Math.toRadians(rotation.field_72449_c));
        newBone.updatePivot((float)(-pivot.field_72450_a), (float)pivot.field_72448_b, (float)pivot.field_72449_c);
        for (Cube cube : bone.cubes()) {
            newBone.getCubes().add(this.constructCube(cube, properties, newBone));
        }
        for (BoneStructure child : boneStructure.children().values()) {
            newBone.getChildBones().add(this.constructBone(child, properties, newBone));
        }
        return newBone;
    }

    @Override
    public GeoCube constructCube(Cube cube, ModelProperties properties, AzBone bone) {
        boolean mirror;
        boolean bl = mirror = cube.mirror() == Boolean.TRUE;
        double inflate = cube.inflate() != null ? cube.inflate() / 16.0 : (bone.getInflate() == null ? 0.0 : bone.getInflate() / 16.0);
        Vec3d size = RenderUtils.arrayToVec(cube.size());
        Vec3d origin = RenderUtils.arrayToVec(cube.origin());
        Vec3d rotation = RenderUtils.arrayToVec(cube.rotation());
        Vec3d pivot = RenderUtils.arrayToVec(cube.pivot());
        origin = new Vec3d(-(origin.field_72450_a + size.field_72450_a) / 16.0, origin.field_72448_b / 16.0, origin.field_72449_c / 16.0);
        Vec3d vertexSize = size.func_216372_d(0.0625, 0.0625, 0.0625);
        pivot = pivot.func_216372_d(-1.0, 1.0, 1.0);
        rotation = new Vec3d(Math.toRadians(-rotation.field_72450_a), Math.toRadians(-rotation.field_72448_b), Math.toRadians(rotation.field_72449_c));
        GeoQuad[] quads = this.buildQuads(cube.uv(), new VertexSet(origin, vertexSize, inflate), cube, (float)properties.textureWidth(), (float)properties.textureHeight(), mirror);
        return new GeoCube(quads, pivot, rotation, size, inflate, mirror);
    }
}

