/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.model.factory.primitive;

import mod.azure.azurelib.cache.object.GeoVertex;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;

public class VertexSet {
    private final GeoVertex bottomLeftBack;
    private final GeoVertex bottomRightBack;
    private final GeoVertex topLeftBack;
    private final GeoVertex topRightBack;
    private final GeoVertex topLeftFront;
    private final GeoVertex topRightFront;
    private final GeoVertex bottomLeftFront;
    private final GeoVertex bottomRightFront;

    public VertexSet(GeoVertex bottomLeftBack, GeoVertex bottomRightBack, GeoVertex topLeftBack, GeoVertex topRightBack, GeoVertex topLeftFront, GeoVertex topRightFront, GeoVertex bottomLeftFront, GeoVertex bottomRightFront) {
        this.bottomLeftBack = bottomLeftBack;
        this.bottomRightBack = bottomRightBack;
        this.topLeftBack = topLeftBack;
        this.topRightBack = topRightBack;
        this.topLeftFront = topLeftFront;
        this.topRightFront = topRightFront;
        this.bottomLeftFront = bottomLeftFront;
        this.bottomRightFront = bottomRightFront;
    }

    public VertexSet(Vec3d origin, Vec3d vertexSize, double inflation) {
        this(new GeoVertex(origin.field_72450_a - inflation, origin.field_72448_b - inflation, origin.field_72449_c - inflation), new GeoVertex(origin.field_72450_a - inflation, origin.field_72448_b - inflation, origin.field_72449_c + vertexSize.field_72449_c + inflation), new GeoVertex(origin.field_72450_a - inflation, origin.field_72448_b + vertexSize.field_72448_b + inflation, origin.field_72449_c - inflation), new GeoVertex(origin.field_72450_a - inflation, origin.field_72448_b + vertexSize.field_72448_b + inflation, origin.field_72449_c + vertexSize.field_72449_c + inflation), new GeoVertex(origin.field_72450_a + vertexSize.field_72450_a + inflation, origin.field_72448_b + vertexSize.field_72448_b + inflation, origin.field_72449_c - inflation), new GeoVertex(origin.field_72450_a + vertexSize.field_72450_a + inflation, origin.field_72448_b + vertexSize.field_72448_b + inflation, origin.field_72449_c + vertexSize.field_72449_c + inflation), new GeoVertex(origin.field_72450_a + vertexSize.field_72450_a + inflation, origin.field_72448_b - inflation, origin.field_72449_c - inflation), new GeoVertex(origin.field_72450_a + vertexSize.field_72450_a + inflation, origin.field_72448_b - inflation, origin.field_72449_c + vertexSize.field_72449_c + inflation));
    }

    public GeoVertex getBottomLeftBack() {
        return this.bottomLeftBack;
    }

    public GeoVertex getBottomRightBack() {
        return this.bottomRightBack;
    }

    public GeoVertex getTopLeftBack() {
        return this.topLeftBack;
    }

    public GeoVertex getTopRightBack() {
        return this.topRightBack;
    }

    public GeoVertex getTopLeftFront() {
        return this.topLeftFront;
    }

    public GeoVertex getTopRightFront() {
        return this.topRightFront;
    }

    public GeoVertex getBottomLeftFront() {
        return this.bottomLeftFront;
    }

    public GeoVertex getBottomRightFront() {
        return this.bottomRightFront;
    }

    public GeoVertex[] quadWest() {
        return new GeoVertex[]{this.topRightBack, this.topLeftBack, this.bottomLeftBack, this.bottomRightBack};
    }

    public GeoVertex[] quadEast() {
        return new GeoVertex[]{this.topLeftFront, this.topRightFront, this.bottomRightFront, this.bottomLeftFront};
    }

    public GeoVertex[] quadNorth() {
        return new GeoVertex[]{this.topLeftBack, this.topLeftFront, this.bottomLeftFront, this.bottomLeftBack};
    }

    public GeoVertex[] quadSouth() {
        return new GeoVertex[]{this.topRightFront, this.topRightBack, this.bottomRightBack, this.bottomRightFront};
    }

    public GeoVertex[] quadUp() {
        return new GeoVertex[]{this.topRightBack, this.topRightFront, this.topLeftFront, this.topLeftBack};
    }

    public GeoVertex[] quadDown() {
        return new GeoVertex[]{this.bottomLeftBack, this.bottomLeftFront, this.bottomRightFront, this.bottomRightBack};
    }

    public GeoVertex[] verticesForQuad(Direction direction, boolean boxUv, boolean mirror) {
        switch (direction) {
            case WEST: {
                return mirror ? this.quadEast() : this.quadWest();
            }
            case EAST: {
                return mirror ? this.quadWest() : this.quadEast();
            }
            case NORTH: {
                return this.quadNorth();
            }
            case SOUTH: {
                return this.quadSouth();
            }
            case UP: {
                return mirror && !boxUv ? this.quadDown() : this.quadUp();
            }
            case DOWN: {
                return mirror && !boxUv ? this.quadUp() : this.quadDown();
            }
        }
        throw new IllegalArgumentException("Unsupported direction: " + direction);
    }
}

