/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.cache.object.GeoQuad;
import mod.azure.azurelib.cache.object.GeoVertex;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;

public class AzModelRenderer<T> {
    private final Matrix4f poseStateCache = new Matrix4f();
    private final Vector3f normalCache = new Vector3f();
    private final AzRendererPipeline<T> rendererPipeline;
    protected final AzLayerRenderer<T> layerRenderer;
    private final Vector4f poseStateTransformCache = new Vector4f();

    public AzModelRenderer(AzRendererPipeline<T> rendererPipeline, AzLayerRenderer<T> layerRenderer) {
        this.layerRenderer = layerRenderer;
        this.rendererPipeline = rendererPipeline;
    }

    protected void render(AzRendererPipelineContext<T> context, boolean isReRender) {
        T animatable = context.animatable();
        AzBakedModel model = context.bakedModel();
        this.rendererPipeline.updateAnimatedTextureFrame(animatable);
        for (AzBone bone : model.getTopLevelBones()) {
            this.renderRecursively(context, bone, isReRender);
        }
    }

    protected void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        MatrixStack poseStack = context.poseStack();
        poseStack.func_227860_a_();
        RenderUtils.prepMatrixForBone(poseStack, bone);
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.func_227865_b_();
    }

    protected void renderCubesOfBone(AzRendererPipelineContext<T> context, AzBone bone) {
        if (bone.isHidden()) {
            return;
        }
        MatrixStack poseStack = context.poseStack();
        for (GeoCube cube : bone.getCubes()) {
            poseStack.func_227860_a_();
            this.renderCube(context, cube);
            poseStack.func_227865_b_();
        }
    }

    protected void renderChildBones(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (AzBone childBone : bone.getChildBones()) {
            this.renderRecursively(context, childBone, isReRender);
        }
    }

    protected void renderCube(AzRendererPipelineContext<T> context, GeoCube cube) {
        MatrixStack poseStack = context.poseStack();
        RenderUtils.translateToPivotPoint(poseStack, cube);
        RenderUtils.rotateMatrixAroundCube(poseStack, cube);
        RenderUtils.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.func_227866_c_().func_227872_b_();
        Matrix4f poseState = poseStack.func_227866_c_().func_227870_a_();
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = quad.getNormal().func_229195_e_();
            normal.func_229188_a_(normalisedPoseState);
            RenderUtils.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(context, quad, poseState, normal);
        }
    }

    protected void createVerticesOfQuad(AzRendererPipelineContext<T> context, GeoQuad quad, Matrix4f poseState, Vector3f normal) {
        IVertexBuilder buffer = context.vertexConsumer();
        int packedOverlay = context.packedOverlay();
        int packedLight = context.packedLight();
        for (GeoVertex vertex : quad.getVertices()) {
            Vector3f position = vertex.position();
            Vector4f vector4f = new Vector4f(position.func_195899_a(), position.func_195900_b(), position.func_195902_c(), 1.0f);
            vector4f.func_229372_a_(poseState);
            buffer.func_225588_a_(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c(), context.red(), context.green(), context.blue(), context.alpha(), vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c());
        }
    }
}

