/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzPhasedRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;

public abstract class AzRendererPipeline<T>
implements AzPhasedRenderer<T> {
    protected final AzRendererConfig<T> config;
    private final AzRendererPipelineContext<T> context;
    private final AzLayerRenderer<T> layerRenderer;
    private final AzModelRenderer<T> modelRenderer;

    protected AzRendererPipeline(AzRendererConfig<T> config) {
        this.config = config;
        this.context = this.createContext(this);
        this.layerRenderer = this.createLayerRenderer(config);
        this.modelRenderer = this.createModelRenderer(this.layerRenderer);
    }

    protected abstract AzRendererPipelineContext<T> createContext(AzRendererPipeline<T> var1);

    protected abstract AzModelRenderer<T> createModelRenderer(AzLayerRenderer<T> var1);

    protected abstract AzLayerRenderer<T> createLayerRenderer(AzRendererConfig<T> var1);

    protected abstract void updateAnimatedTextureFrame(T var1);

    public void render(MatrixStack poseStack, AzBakedModel model, T animatable, IRenderTypeBuffer bufferSource, RenderType renderType, IVertexBuilder buffer, float yaw, float partialTick, int packedLight) {
        renderType = this.config.getRenderType(animatable);
        this.context.populate(animatable, model, bufferSource, packedLight, partialTick, poseStack, renderType, buffer);
        poseStack.func_227860_a_();
        this.preRender(this.context, false);
        this.layerRenderer.preApplyRenderLayers(this.context);
        this.modelRenderer.render(this.context, false);
        this.layerRenderer.applyRenderLayers(this.context);
        this.postRender(this.context, false);
        poseStack.func_227865_b_();
        this.renderFinal(this.context);
        this.doPostRenderCleanup();
    }

    public void reRender(AzRendererPipelineContext<T> context) {
        MatrixStack poseStack = context.poseStack();
        poseStack.func_227860_a_();
        this.preRender(context, true);
        this.modelRenderer.render(context, true);
        this.postRender(context, true);
        poseStack.func_227865_b_();
    }

    protected void renderFinal(AzRendererPipelineContext<T> context) {
    }

    protected void doPostRenderCleanup() {
    }

    protected void scaleModelForRender(AzRendererPipelineContext<T> context, float widthScale, float heightScale, boolean isReRender) {
        if (!(isReRender || widthScale == 1.0f && heightScale == 1.0f)) {
            MatrixStack poseStack = context.poseStack();
            poseStack.func_227862_a_(widthScale, heightScale, widthScale);
        }
    }

    public AzRendererConfig<T> config() {
        return this.config;
    }

    public AzRendererPipelineContext<T> context() {
        return this.context;
    }
}

