/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Objects;
import mod.azure.azurelib.core.object.Color;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;

public abstract class AzRendererPipelineContext<T> {
    private final AzRendererPipeline<T> rendererPipeline;
    private T animatable;
    private AzBakedModel bakedModel;
    private IRenderTypeBuffer multiBufferSource;
    private int packedLight;
    private int packedOverlay;
    private float partialTick;
    private MatrixStack poseStack;
    private float red;
    private float green;
    private float blue;
    private float alpha;
    private RenderType renderType;
    private IVertexBuilder vertexConsumer;

    protected AzRendererPipelineContext(AzRendererPipeline<T> rendererPipeline) {
        this.rendererPipeline = rendererPipeline;
    }

    public void populate(T animatable, AzBakedModel bakedModel, IRenderTypeBuffer multiBufferSource, int packedLight, float partialTick, MatrixStack poseStack, RenderType renderType, IVertexBuilder vertexConsumer) {
        this.animatable = animatable;
        this.bakedModel = bakedModel;
        this.multiBufferSource = multiBufferSource;
        this.packedLight = packedLight;
        this.packedOverlay = this.getPackedOverlay(animatable, 0.0f, partialTick);
        this.partialTick = partialTick;
        this.poseStack = poseStack;
        this.renderType = renderType;
        this.vertexConsumer = vertexConsumer;
        Color renderColor = this.getRenderColor(animatable, partialTick, packedLight);
        this.red = renderColor.getRedFloat();
        this.green = renderColor.getGreenFloat();
        this.blue = renderColor.getBlueFloat();
        this.alpha = renderColor.getAlphaFloat();
        if (renderType == null) {
            ResourceLocation textureLocation = this.rendererPipeline.config().textureLocation(animatable);
            this.renderType = this.getDefaultRenderType(animatable, textureLocation, multiBufferSource, partialTick);
        }
        Objects.requireNonNull(this.renderType);
        if (vertexConsumer == null) {
            this.vertexConsumer = multiBufferSource.getBuffer(this.renderType);
        }
    }

    public abstract RenderType getDefaultRenderType(T var1, ResourceLocation var2, IRenderTypeBuffer var3, float var4);

    public Color getRenderColor(T animatable, float partialTick, int packedLight) {
        return Color.WHITE;
    }

    protected int getPackedOverlay(T animatable, float u, float partialTick) {
        return OverlayTexture.field_229196_a_;
    }

    public AzRendererPipeline<T> rendererPipeline() {
        return this.rendererPipeline;
    }

    public T animatable() {
        return this.animatable;
    }

    public AzBakedModel bakedModel() {
        return this.bakedModel;
    }

    public IRenderTypeBuffer multiBufferSource() {
        return this.multiBufferSource;
    }

    public float red() {
        return this.red;
    }

    public float green() {
        return this.green;
    }

    public float blue() {
        return this.blue;
    }

    public float alpha() {
        return this.alpha;
    }

    public void setRed(float red) {
        this.red = red;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setColor(Color color) {
        this.red = color.getRedFloat();
        this.green = color.getGreenFloat();
        this.blue = color.getBlueFloat();
    }

    public int packedLight() {
        return this.packedLight;
    }

    public void setPackedLight(int packedLight) {
        this.packedLight = packedLight;
    }

    public int packedOverlay() {
        return this.packedOverlay;
    }

    public void setPackedOverlay(int packedOverlay) {
        this.packedOverlay = packedOverlay;
    }

    public float partialTick() {
        return this.partialTick;
    }

    public MatrixStack poseStack() {
        return this.poseStack;
    }

    public RenderType renderType() {
        return this.renderType;
    }

    public void setRenderType(RenderType renderType) {
        this.renderType = renderType;
    }

    public IVertexBuilder vertexConsumer() {
        return this.vertexConsumer;
    }

    public void setVertexConsumer(IVertexBuilder vertexConsumer) {
        this.vertexConsumer = vertexConsumer;
    }
}

