/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.AzArmorModel;
import mod.azure.azurelib.rewrite.render.armor.AzArmorModelRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererConfig;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneContext;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;

public class AzArmorRendererPipeline
extends AzRendererPipeline<ItemStack> {
    private final AzArmorModel<?> armorModel;
    private final AzArmorRenderer armorRenderer;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzArmorRendererPipeline(AzRendererConfig<ItemStack> config, AzArmorRenderer armorRenderer) {
        super(config);
        this.armorModel = new AzArmorModel(this);
        this.armorRenderer = armorRenderer;
    }

    @Override
    protected AzRendererPipelineContext<ItemStack> createContext(AzRendererPipeline<ItemStack> rendererPipeline) {
        return new AzArmorRendererPipelineContext(rendererPipeline);
    }

    @Override
    protected AzModelRenderer<ItemStack> createModelRenderer(AzLayerRenderer<ItemStack> layerRenderer) {
        return new AzArmorModelRenderer(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<ItemStack> createLayerRenderer(AzRendererConfig<ItemStack> config) {
        return new AzLayerRenderer<ItemStack>(config::renderLayers);
    }

    @Override
    protected void updateAnimatedTextureFrame(ItemStack animatable) {
        Entity currentEntity = this.context().currentEntity();
        if (currentEntity != null) {
            AnimatableTexture.setAndUpdate(this.config.textureLocation(animatable));
        }
    }

    @Override
    public void preRender(AzRendererPipelineContext<ItemStack> context, boolean isReRender) {
        AzArmorRendererPipelineContext armorContext = (AzArmorRendererPipelineContext)context;
        BipedModel<?> baseModel = armorContext.baseModel();
        AzArmorBoneContext boneContext = armorContext.boneContext();
        AzArmorRendererConfig config = this.config();
        EquipmentSlotType currentSlot = armorContext.currentSlot();
        float scaleWidth = config.scaleWidth(context.animatable());
        float scaleHeight = config.scaleHeight(context.animatable());
        ItemStack animatable = (ItemStack)armorContext.animatable();
        AzBakedModel model = this.armorRenderer.provider().provideBakedModel(animatable);
        MatrixStack poseStack = armorContext.poseStack();
        this.entityRenderTranslations = new Matrix4f(poseStack.func_227866_c_().func_227870_a_());
        this.armorModel.applyBaseModel(baseModel);
        boneContext.grabRelevantBones(model, config.boneProvider());
        boneContext.applyBaseTransformations(baseModel);
        this.scaleModelForBaby(armorContext, isReRender);
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        boneContext.applyBoneVisibilityBySlot(currentSlot);
        if (config.alpha(context.animatable()) < 1.0f) {
            armorContext.setAlpha(config.alpha(context.animatable()));
            armorContext.setTranslucent(true);
        }
        config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<ItemStack> context, boolean isReRender) {
        this.config.postRenderEntry(context);
    }

    public void scaleModelForBaby(AzArmorRendererPipelineContext context, boolean isReRender) {
        if (!this.armorModel.field_217114_e || isReRender) {
            return;
        }
        BipedModel<?> baseModel = context.baseModel();
        EquipmentSlotType currentSlot = context.currentSlot();
        MatrixStack poseStack = context.poseStack();
        if (currentSlot == EquipmentSlotType.HEAD) {
            if (baseModel.field_228221_a_) {
                float headScale = 1.5f / baseModel.field_228224_g_;
                poseStack.func_227862_a_(headScale, headScale, headScale);
            }
            poseStack.func_227861_a_(0.0, (double)(baseModel.field_228226_i_ / 16.0f), (double)(baseModel.field_228223_f_ / 16.0f));
        } else {
            float bodyScale = 1.0f / baseModel.field_228225_h_;
            poseStack.func_227862_a_(bodyScale, bodyScale, bodyScale);
            poseStack.func_227861_a_(0.0, (double)(baseModel.field_228226_i_ / 16.0f), 0.0);
        }
    }

    public AzArmorModel<?> armorModel() {
        return this.armorModel;
    }

    public AzArmorRendererConfig config() {
        return (AzArmorRendererConfig)super.config();
    }

    public AzArmorRendererPipelineContext context() {
        return (AzArmorRendererPipelineContext)super.context();
    }

    public AzArmorRenderer renderer() {
        return this.armorRenderer;
    }
}

