/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.armor;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import net.minecraft.item.Item;

public class AzArmorRendererRegistry {
    private static final Map<Item, AzArmorRenderer> ITEM_TO_RENDERER = new HashMap<Item, AzArmorRenderer>();
    private static final Map<Item, Supplier<AzArmorRenderer>> ITEM_TO_RENDERER_SUPPLIER = new HashMap<Item, Supplier<AzArmorRenderer>>();

    public static void register(Item item, Supplier<AzArmorRenderer> armorRendererSupplier) {
        ITEM_TO_RENDERER_SUPPLIER.put(item, armorRendererSupplier);
    }

    public static void register(Supplier<AzArmorRenderer> armorRendererSupplier, Item item, Item ... items) {
        AzArmorRendererRegistry.register(item, armorRendererSupplier);
        for (Item otherItem : items) {
            AzArmorRendererRegistry.register(otherItem, armorRendererSupplier);
        }
    }

    public static AzArmorRenderer getOrNull(Item item) {
        return ITEM_TO_RENDERER.computeIfAbsent(item, $ -> {
            Supplier<AzArmorRenderer> rendererSupplier = ITEM_TO_RENDERER_SUPPLIER.get(item);
            return rendererSupplier == null ? null : rendererSupplier.get();
        });
    }
}

