/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.armor.bone;

import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneProvider;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.inventory.EquipmentSlotType;

public class AzArmorBoneContext {
    private AzBakedModel lastModel;
    protected AzBone head = null;
    protected AzBone body = null;
    protected AzBone rightArm = null;
    protected AzBone leftArm = null;
    protected AzBone rightLeg = null;
    protected AzBone leftLeg = null;
    protected AzBone rightBoot = null;
    protected AzBone leftBoot = null;

    public void setAllVisible(boolean pVisible) {
        this.setBoneVisible(this.head, pVisible);
        this.setBoneVisible(this.body, pVisible);
        this.setBoneVisible(this.rightArm, pVisible);
        this.setBoneVisible(this.leftArm, pVisible);
        this.setBoneVisible(this.rightLeg, pVisible);
        this.setBoneVisible(this.leftLeg, pVisible);
        this.setBoneVisible(this.rightBoot, pVisible);
        this.setBoneVisible(this.leftBoot, pVisible);
    }

    public void grabRelevantBones(AzBakedModel model, AzArmorBoneProvider boneProvider) {
        if (this.lastModel == model) {
            return;
        }
        this.lastModel = model;
        this.head = boneProvider.getHeadBone(model);
        this.body = boneProvider.getBodyBone(model);
        this.rightArm = boneProvider.getRightArmBone(model);
        this.leftArm = boneProvider.getLeftArmBone(model);
        this.rightLeg = boneProvider.getRightLegBone(model);
        this.leftLeg = boneProvider.getLeftLegBone(model);
        this.rightBoot = boneProvider.getRightBootBone(model);
        this.leftBoot = boneProvider.getLeftBootBone(model);
    }

    public void applyBaseTransformations(BipedModel<?> baseModel) {
        if (this.head != null) {
            ModelRenderer headPart = baseModel.field_78116_c;
            RenderUtils.matchModelPartRot(headPart, this.head);
            this.head.updatePosition(headPart.field_78800_c, -headPart.field_78797_d, headPart.field_78798_e);
        }
        if (this.body != null) {
            ModelRenderer bodyPart = baseModel.field_78115_e;
            RenderUtils.matchModelPartRot(bodyPart, this.body);
            this.body.updatePosition(bodyPart.field_78800_c, -bodyPart.field_78797_d, bodyPart.field_78798_e);
        }
        if (this.rightArm != null) {
            ModelRenderer rightArmPart = baseModel.field_178723_h;
            RenderUtils.matchModelPartRot(rightArmPart, this.rightArm);
            this.rightArm.updatePosition(rightArmPart.field_78800_c + 5.0f, 2.0f - rightArmPart.field_78797_d, rightArmPart.field_78798_e);
        }
        if (this.leftArm != null) {
            ModelRenderer leftArmPart = baseModel.field_178724_i;
            RenderUtils.matchModelPartRot(leftArmPart, this.leftArm);
            this.leftArm.updatePosition(leftArmPart.field_78800_c - 5.0f, 2.0f - leftArmPart.field_78797_d, leftArmPart.field_78798_e);
        }
        if (this.rightLeg != null) {
            ModelRenderer rightLegPart = baseModel.field_178721_j;
            RenderUtils.matchModelPartRot(rightLegPart, this.rightLeg);
            this.rightLeg.updatePosition(rightLegPart.field_78800_c + 2.0f, 12.0f - rightLegPart.field_78797_d, rightLegPart.field_78798_e);
            if (this.rightBoot != null) {
                RenderUtils.matchModelPartRot(rightLegPart, this.rightBoot);
                this.rightBoot.updatePosition(rightLegPart.field_78800_c + 2.0f, 12.0f - rightLegPart.field_78797_d, rightLegPart.field_78798_e);
            }
        }
        if (this.leftLeg != null) {
            ModelRenderer leftLegPart = baseModel.field_178722_k;
            RenderUtils.matchModelPartRot(leftLegPart, this.leftLeg);
            this.leftLeg.updatePosition(leftLegPart.field_78800_c - 2.0f, 12.0f - leftLegPart.field_78797_d, leftLegPart.field_78798_e);
            if (this.leftBoot != null) {
                RenderUtils.matchModelPartRot(leftLegPart, this.leftBoot);
                this.leftBoot.updatePosition(leftLegPart.field_78800_c - 2.0f, 12.0f - leftLegPart.field_78797_d, leftLegPart.field_78798_e);
            }
        }
    }

    public void applyBoneVisibilityByPart(EquipmentSlotType currentSlot, ModelRenderer currentPart, BipedModel<?> model) {
        this.setAllVisible(false);
        currentPart.field_78806_j = true;
        AzBone bone = null;
        if (currentPart == model.field_178720_f || currentPart == model.field_78116_c) {
            bone = this.head;
        } else if (currentPart == model.field_78115_e) {
            bone = this.body;
        } else if (currentPart == model.field_178724_i) {
            bone = this.leftArm;
        } else if (currentPart == model.field_178723_h) {
            bone = this.rightArm;
        } else if (currentPart == model.field_178722_k) {
            bone = currentSlot == EquipmentSlotType.FEET ? this.leftBoot : this.leftLeg;
        } else if (currentPart == model.field_178721_j) {
            AzBone azBone = bone = currentSlot == EquipmentSlotType.FEET ? this.rightBoot : this.rightLeg;
        }
        if (bone != null) {
            bone.setHidden(false);
        }
    }

    public void applyBoneVisibilityBySlot(EquipmentSlotType currentSlot) {
        this.setAllVisible(false);
        switch (currentSlot) {
            case HEAD: {
                this.setBoneVisible(this.head, true);
                break;
            }
            case CHEST: {
                this.setBoneVisible(this.body, true);
                this.setBoneVisible(this.rightArm, true);
                this.setBoneVisible(this.leftArm, true);
                break;
            }
            case LEGS: {
                this.setBoneVisible(this.rightLeg, true);
                this.setBoneVisible(this.leftLeg, true);
                break;
            }
            case FEET: {
                this.setBoneVisible(this.rightBoot, true);
                this.setBoneVisible(this.leftBoot, true);
                break;
            }
        }
    }

    protected void setBoneVisible(AzBone bone, boolean visible) {
        if (bone == null) {
            return;
        }
        bone.setHidden(!visible);
    }
}

