/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mod.azure.azurelib.rewrite.animation.impl.AzBlockAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRendererPipeline;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class AzBlockEntityModelRenderer<T extends TileEntity>
extends AzModelRenderer<T> {
    private final AzBlockEntityRendererPipeline<T> blockEntityRendererPipeline;

    public AzBlockEntityModelRenderer(AzBlockEntityRendererPipeline<T> blockEntityRendererPipeline, AzLayerRenderer<T> layerRenderer) {
        super(blockEntityRendererPipeline, layerRenderer);
        this.blockEntityRendererPipeline = blockEntityRendererPipeline;
    }

    @Override
    public void render(AzRendererPipelineContext<T> context, boolean isReRender) {
        TileEntity entity = (TileEntity)context.animatable();
        MatrixStack poseStack = context.poseStack();
        if (!isReRender) {
            poseStack.func_227861_a_(0.5, 0.0, 0.5);
            this.rotateBlock(this.getFacing(entity), poseStack);
            AzBlockAnimator<TileEntity> animator = this.blockEntityRendererPipeline.getRenderer().getAnimator();
            if (animator != null) {
                animator.animate(entity, context.partialTick());
            }
        }
        this.blockEntityRendererPipeline.modelRenderTranslations = new Matrix4f(poseStack.func_227866_c_().func_227870_a_());
        super.render(context, isReRender);
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        IVertexBuilder buffer = context.vertexConsumer();
        IRenderTypeBuffer bufferSource = context.multiBufferSource();
        TileEntity entity = (TileEntity)context.animatable();
        MatrixStack poseStack = context.poseStack();
        RenderType renderType = context.renderType();
        poseStack.func_227860_a_();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f(poseStack.func_227866_c_().func_227870_a_());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.blockEntityRendererPipeline.entityRenderTranslations);
            BlockPos pos = entity.func_174877_v();
            Matrix4f worldState = new Matrix4f(localMatrix);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.blockEntityRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(localMatrix);
            worldState.func_226597_a_(new Vector3f((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p()));
            bone.setWorldSpaceMatrix(worldState);
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        if (!isReRender && buffer instanceof BufferBuilder && !((BufferBuilder)buffer).field_179010_r) {
            context.setVertexConsumer(bufferSource.getBuffer(renderType));
        }
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.func_227865_b_();
    }

    protected Direction getFacing(T block) {
        BlockState blockState = block.func_195044_w();
        if (blockState.func_196959_b((IProperty)HorizontalBlock.field_185512_D)) {
            return (Direction)blockState.func_177229_b((IProperty)HorizontalBlock.field_185512_D);
        }
        if (blockState.func_196959_b((IProperty)DirectionalBlock.field_176387_N)) {
            return (Direction)blockState.func_177229_b((IProperty)DirectionalBlock.field_176387_N);
        }
        return Direction.NORTH;
    }

    protected void rotateBlock(Direction facing, MatrixStack poseStack) {
        switch (facing) {
            case SOUTH: {
                poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                break;
            }
            case WEST: {
                poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                break;
            }
            case NORTH: {
                poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(0.0f));
                break;
            }
            case EAST: {
                poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
                break;
            }
            case UP: {
                poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                break;
            }
            case DOWN: {
                poseStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(90.0f));
            }
        }
    }
}

