/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import mod.azure.azurelib.rewrite.animation.impl.AzBlockAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzProvider;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRendererPipeline;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;

public abstract class AzBlockEntityRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    private final AzProvider<T> provider = new AzProvider<TileEntity>(config::createAnimator, config::modelLocation);
    private final AzBlockEntityRendererPipeline<T> rendererPipeline;
    private AzBlockAnimator<T> reusedAzBlockAnimator;

    protected AzBlockEntityRenderer(AzBlockEntityRendererConfig<T> config, TileEntityRendererDispatcher context) {
        super(context);
        this.rendererPipeline = this.createPipeline(config);
    }

    protected AzBlockEntityRendererPipeline<T> createPipeline(AzBlockEntityRendererConfig<T> config) {
        return new AzBlockEntityRendererPipeline<T>(config, this);
    }

    public void func_225616_a_(T entity, float partialTick, MatrixStack poseStack, IRenderTypeBuffer source, int packedLight, int packedOverlay) {
        AzBlockAnimator cachedEntityAnimator = (AzBlockAnimator)this.provider.provideAnimator(entity);
        AzBakedModel model = this.provider.provideBakedModel(entity);
        AzRendererPipelineContext context = this.rendererPipeline.context();
        if (cachedEntityAnimator != null && model != null) {
            cachedEntityAnimator.setActiveModel(model);
        }
        this.reusedAzBlockAnimator = cachedEntityAnimator;
        this.rendererPipeline.render(poseStack, model, entity, source, null, null, 0.0f, partialTick, packedLight);
    }

    public AzBlockAnimator<T> getAnimator() {
        return this.reusedAzBlockAnimator;
    }
}

