/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.LightType;

public class AzEntityLeashRenderUtil {
    public static <T extends Entity, E extends Entity, M extends MobEntity> void renderLeash(AzEntityRenderer<T> azEntityRenderer, M mob, float partialTick, MatrixStack poseStack, IRenderTypeBuffer bufferSource, E leashHolder) {
        int segment;
        double lerpBodyAngle = MathHelper.func_219799_g((float)partialTick, (float)mob.field_70760_ar, (float)mob.field_70761_aq) * ((float)Math.PI / 180) + 1.5707964f;
        Vector3d leashOffset = new Vector3d(0.0, (double)mob.func_70047_e(), (double)(mob.func_213311_cf() * 0.4f));
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffset.field_181061_c + Math.sin(lerpBodyAngle) * leashOffset.field_181059_a;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffset.field_181061_c - Math.cos(lerpBodyAngle) * leashOffset.field_181059_a;
        double lerpOriginX = MathHelper.func_219803_d((double)partialTick, (double)mob.field_70169_q, (double)mob.func_226277_ct_()) + xAngleOffset;
        double lerpOriginY = MathHelper.func_219803_d((double)partialTick, (double)mob.field_70167_r, (double)mob.func_226278_cu_()) + leashOffset.field_181060_b;
        double lerpOriginZ = MathHelper.func_219803_d((double)partialTick, (double)mob.field_70166_s, (double)mob.func_226281_cx_()) + zAngleOffset;
        Vec3d ropeGripPosition = leashHolder.func_174791_d().func_72441_c(0.0, (double)leashHolder.func_70047_e() * 0.7, 0.0);
        float xDif = (float)(ropeGripPosition.field_72450_a - lerpOriginX);
        float yDif = (float)(ropeGripPosition.field_72448_b - lerpOriginY);
        float zDif = (float)(ropeGripPosition.field_72449_c - lerpOriginZ);
        float offsetMod = MathHelper.func_226165_i_((float)(xDif * xDif + zDif * zDif)) * 0.025f / 2.0f;
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        IVertexBuilder vertexConsumer = bufferSource.getBuffer(RenderType.func_228649_h_());
        BlockPos entityEyePos = new BlockPos(mob.func_174824_e(partialTick));
        BlockPos holderEyePos = new BlockPos(leashHolder.func_174824_e(partialTick));
        int entityBlockLight = azEntityRenderer.func_225624_a_(mob, entityEyePos.func_177956_o());
        int holderBlockLight = leashHolder.func_70027_ad() ? 15 : leashHolder.field_70170_p.func_226658_a_(LightType.BLOCK, holderEyePos);
        int entitySkyLight = mob.field_70170_p.func_226658_a_(LightType.SKY, entityEyePos);
        int holderSkyLight = mob.field_70170_p.func_226658_a_(LightType.SKY, holderEyePos);
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(xAngleOffset, leashOffset.field_181060_b, zAngleOffset);
        Matrix4f posMatrix = new Matrix4f(poseStack.func_227866_c_().func_227870_a_());
        for (segment = 0; segment <= 24; ++segment) {
            AzEntityLeashRenderUtil.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.025f, xOffset, zOffset, segment, false);
        }
        for (segment = 24; segment >= 0; --segment) {
            AzEntityLeashRenderUtil.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.0f, xOffset, zOffset, segment, true);
        }
        poseStack.func_227865_b_();
    }

    private static void renderLeashPiece(IVertexBuilder buffer, Matrix4f positionMatrix, float xDif, float yDif, float zDif, int entityBlockLight, int holderBlockLight, int entitySkyLight, int holderSkyLight, float width, float yOffset, float xOffset, float zOffset, int segment, boolean isLeashKnot) {
        float piecePosPercent = (float)segment / 24.0f;
        int lerpBlockLight = (int)MathHelper.func_219799_g((float)piecePosPercent, (float)entityBlockLight, (float)holderBlockLight);
        int lerpSkyLight = (int)MathHelper.func_219799_g((float)piecePosPercent, (float)entitySkyLight, (float)holderSkyLight);
        int packedLight = LightTexture.func_228451_a_((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = segment % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = xDif * piecePosPercent;
        float y = yDif > 0.0f ? yDif * piecePosPercent * piecePosPercent : yDif - yDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = zDif * piecePosPercent;
        buffer.func_227888_a_(positionMatrix, x - xOffset, y + yOffset, z + zOffset).func_227885_a_(red, green, blue, 1.0f).func_227886_a_(packedLight).func_181675_d();
        buffer.func_227888_a_(positionMatrix, x + xOffset, y + width - yOffset, z - zOffset).func_227885_a_(red, green, blue, 1.0f).func_227886_a_(packedLight).func_181675_d();
    }

    private AzEntityLeashRenderUtil() {
        throw new UnsupportedOperationException();
    }
}

