/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mod.azure.azurelib.rewrite.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipeline;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class AzEntityModelRenderer<T extends Entity>
extends AzModelRenderer<T> {
    private final AzEntityRendererPipeline<T> entityRendererPipeline;

    public AzEntityModelRenderer(AzEntityRendererPipeline<T> entityRendererPipeline, AzLayerRenderer<T> layerRenderer) {
        super(entityRendererPipeline, layerRenderer);
        this.entityRendererPipeline = entityRendererPipeline;
    }

    @Override
    public void render(AzRendererPipelineContext<T> context, boolean isReRender) {
        AzEntityAnimator<Entity> animator;
        Direction bedDirection;
        Entity animatable = (Entity)context.animatable();
        float partialTick = context.partialTick();
        MatrixStack poseStack = context.poseStack();
        poseStack.func_227860_a_();
        LivingEntity livingEntity = animatable instanceof LivingEntity ? (LivingEntity)animatable : null;
        boolean shouldSit = animatable.func_184218_aH() && animatable.func_184187_bx() != null;
        float lerpBodyRot = livingEntity == null ? 0.0f : MathHelper.func_226167_j_((float)partialTick, (float)livingEntity.field_70760_ar, (float)livingEntity.field_70761_aq);
        float lerpHeadRot = livingEntity == null ? 0.0f : MathHelper.func_226167_j_((float)partialTick, (float)livingEntity.field_70758_at, (float)livingEntity.field_70759_as);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && animatable.func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)animatable.func_184187_bx();
            lerpBodyRot = MathHelper.func_226167_j_((float)partialTick, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (animatable.func_213283_Z() == Pose.SLEEPING && livingEntity != null && (bedDirection = livingEntity.func_213376_dz()) != null) {
            float eyePosOffset = livingEntity.func_213307_e(Pose.STANDING) - 0.1f;
            poseStack.func_227861_a_((double)((float)(-bedDirection.func_82601_c()) * eyePosOffset), 0.0, (double)((float)(-bedDirection.func_82601_c()) * eyePosOffset));
        }
        float nativeScale = livingEntity != null ? livingEntity.func_213355_cm() : 1.0f;
        float ageInTicks = (float)animatable.field_70173_aa + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        poseStack.func_227862_a_(nativeScale, nativeScale, nativeScale);
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick, nativeScale);
        if (!shouldSit && animatable.func_70089_S() && livingEntity != null) {
            limbSwingAmount = MathHelper.func_219799_g((float)partialTick, (float)livingEntity.field_184618_aE, (float)livingEntity.field_70721_aZ);
            limbSwing = livingEntity.field_184619_aG - livingEntity.field_70721_aZ * (1.0f - partialTick);
            if (livingEntity.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        if (!isReRender && (animator = this.entityRendererPipeline.getRenderer().getAnimator()) != null) {
            animator.animate(animatable, context.partialTick());
        }
        RenderUtils.copy(this.entityRendererPipeline.modelRenderTranslations, poseStack.func_227866_c_().func_227870_a_());
        if (!animatable.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            super.render(context, isReRender);
        }
        poseStack.func_227865_b_();
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        IVertexBuilder buffer = context.vertexConsumer();
        IRenderTypeBuffer bufferSource = context.multiBufferSource();
        Entity entity = (Entity)context.animatable();
        MatrixStack poseStack = context.poseStack();
        RenderType renderType = context.renderType();
        poseStack.func_227860_a_();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f(poseStack.func_227866_c_().func_227870_a_());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRendererPipeline.entityRenderTranslations);
            Matrix4f worldState = localMatrix.func_226601_d_();
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(localMatrix);
            worldState.func_226597_a_(new Vector3f(entity.func_213303_ch()));
            bone.setWorldSpaceMatrix(worldState);
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        if (!isReRender && buffer instanceof BufferBuilder && !((BufferBuilder)buffer).field_179010_r) {
            context.setVertexConsumer(bufferSource.getBuffer(renderType));
        }
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.func_227865_b_();
    }

    protected void applyRotations(T animatable, MatrixStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        this.applyRotations(animatable, poseStack, ageInTicks, rotationYaw, partialTick, 1.0f);
    }

    protected void applyRotations(T animatable, MatrixStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        if (this.isShaking(animatable)) {
            rotationYaw += (float)(Math.cos((double)((Entity)animatable).field_70173_aa * 3.25) * Math.PI * 0.4);
        }
        if (animatable.func_213283_Z() != Pose.SLEEPING) {
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
        }
        if (animatable instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)animatable;
            AzEntityRendererConfig<T> config = this.entityRendererPipeline.getRenderer().config();
            float deathMaxRotation = config.getDeathMaxRotation(animatable);
            if (livingEntity.field_70725_aQ > 0) {
                float deathRotation = ((float)livingEntity.field_70725_aQ + partialTick - 1.0f) / 20.0f * 1.6f;
                poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(Math.min(MathHelper.func_76129_c((float)deathRotation), 1.0f) * deathMaxRotation));
            } else if (livingEntity.func_204805_cN()) {
                poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f - livingEntity.field_70125_A));
                poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)livingEntity.field_70173_aa + partialTick) * -75.0f));
            } else if (animatable.func_213283_Z() == Pose.SLEEPING) {
                Direction bedOrientation = livingEntity.func_213376_dz();
                poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(bedOrientation != null ? RenderUtils.getDirectionAngle(bedOrientation) : rotationYaw));
                poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(deathMaxRotation));
                poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
            } else if (this.isEntityUpsideDown(livingEntity)) {
                poseStack.func_227861_a_(0.0, (double)((animatable.func_213302_cg() + 0.1f) / nativeScale), 0.0);
                poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            }
        }
    }

    public boolean isEntityUpsideDown(LivingEntity livingEntity) {
        String s;
        if ((livingEntity instanceof PlayerEntity || livingEntity.func_145818_k_()) && ("Dinnerbone".equals(s = TextFormatting.func_110646_a((String)livingEntity.func_200200_C_().getString())) || "Grumm".equals(s))) {
            return !(livingEntity instanceof PlayerEntity) || ((PlayerEntity)livingEntity).func_175148_a(PlayerModelPart.CAPE);
        }
        return false;
    }

    public boolean isShaking(T entity) {
        return false;
    }
}

