/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import mod.azure.azurelib.rewrite.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzProvider;
import mod.azure.azurelib.rewrite.render.entity.AzEntityNameRenderUtil;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipeline;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public abstract class AzEntityRenderer<T extends Entity>
extends EntityRenderer<T> {
    private final AzEntityRendererConfig<T> config;
    private final AzProvider<T> provider;
    private final AzEntityRendererPipeline<T> rendererPipeline;
    private AzEntityAnimator<T> reusedAzEntityAnimator;

    protected AzEntityRenderer(AzEntityRendererConfig<T> config, EntityRendererManager context) {
        super(context);
        this.config = config;
        this.provider = new AzProvider<Entity>(config::createAnimator, config::modelLocation);
        this.rendererPipeline = this.createPipeline(config);
    }

    protected AzEntityRendererPipeline<T> createPipeline(AzEntityRendererConfig<T> config) {
        return new AzEntityRendererPipeline<T>(config, this);
    }

    public final ResourceLocation func_110775_a(T animatable) {
        return this.config.textureLocation(animatable);
    }

    public void superRender(T entity, float entityYaw, float partialTick, MatrixStack poseStack, IRenderTypeBuffer bufferSource, int packedLight) {
        super.func_225623_a_(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void func_225623_a_(T entity, float entityYaw, float partialTick, MatrixStack poseStack, IRenderTypeBuffer bufferSource, int packedLight) {
        AzEntityAnimator cachedEntityAnimator = (AzEntityAnimator)this.provider.provideAnimator(entity);
        AzBakedModel azBakedModel = this.provider.provideBakedModel(entity);
        if (cachedEntityAnimator != null && azBakedModel != null) {
            cachedEntityAnimator.setActiveModel(azBakedModel);
        }
        this.field_76987_f = this.config.shadowRadius(entity);
        this.reusedAzEntityAnimator = cachedEntityAnimator;
        this.rendererPipeline.render(poseStack, azBakedModel, entity, bufferSource, null, null, entityYaw, partialTick, packedLight);
    }

    public boolean func_177070_b(T entity) {
        return AzEntityNameRenderUtil.shouldShowName(this.field_76990_c, entity);
    }

    protected int func_225624_a_(T entity, float pos) {
        return super.func_225624_a_(entity, pos);
    }

    public AzEntityAnimator<T> getAnimator() {
        return this.reusedAzEntityAnimator;
    }

    public AzEntityRendererConfig<T> config() {
        return this.config;
    }
}

