/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import mod.azure.azurelib.rewrite.animation.impl.AzItemAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererPipeline;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;

public class AzItemModelRenderer
extends AzModelRenderer<ItemStack> {
    private final AzItemRendererPipeline itemRendererPipeline;

    public AzItemModelRenderer(AzItemRendererPipeline itemRendererPipeline, AzLayerRenderer<ItemStack> layerRenderer) {
        super(itemRendererPipeline, layerRenderer);
        this.itemRendererPipeline = itemRendererPipeline;
    }

    @Override
    public void render(AzRendererPipelineContext<ItemStack> context, boolean isReRender) {
        if (!isReRender) {
            ItemStack animatable = context.animatable();
            AzItemAnimator animator = this.itemRendererPipeline.getRenderer().getAnimator();
            if (animator != null) {
                animator.animate(animatable, context.partialTick());
            }
        }
        MatrixStack poseStack = context.poseStack();
        this.itemRendererPipeline.modelRenderTranslations = new Matrix4f(poseStack.func_227866_c_().func_227870_a_());
        super.render(context, isReRender);
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<ItemStack> context, AzBone bone, boolean isReRender) {
        if (bone.isTrackingMatrices()) {
            ItemStack animatable = context.animatable();
            MatrixStack poseStack = context.poseStack();
            Matrix4f poseState = new Matrix4f(poseStack.func_227866_c_().func_227870_a_());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRendererPipeline.itemRenderTranslations);
            Matrix4f worldState = localMatrix.func_226601_d_();
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRendererPipeline.modelRenderTranslations));
            worldState.func_226597_a_(new Vector3f(this.getRenderOffset(animatable, 1.0f)));
            bone.setWorldSpaceMatrix(worldState);
        }
        super.renderRecursively(context, bone, isReRender);
    }

    public Vec3d getRenderOffset(ItemStack itemStack, float f) {
        return Vec3d.field_186680_a;
    }
}

