/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mod.azure.azurelib.rewrite.animation.impl.AzItemAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzProvider;
import mod.azure.azurelib.rewrite.render.item.AzItemGuiRenderUtil;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererConfig;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererPipeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class AzItemRenderer {
    private final AzItemRendererConfig config;
    private final AzProvider<ItemStack> provider;
    public final AzItemRendererPipeline rendererPipeline;
    private AzItemAnimator reusedAzItemAnimator;

    protected AzItemRenderer(AzItemRendererConfig config) {
        this.rendererPipeline = this.createPipeline(config);
        this.provider = new AzProvider<ItemStack>(config::createAnimator, config::modelLocation);
        this.config = config;
    }

    protected AzItemRendererPipeline createPipeline(AzItemRendererConfig config) {
        return new AzItemRendererPipeline(config, this);
    }

    public void renderByGui(ItemStack stack, MatrixStack poseStack, IRenderTypeBuffer source, int packedLight) {
        AzBakedModel model = this.provider.provideBakedModel(stack);
        this.prepareAnimator(stack, model);
        AzItemGuiRenderUtil.renderInGui(this.config, this.rendererPipeline, stack, model, stack, poseStack, source, packedLight);
    }

    public void renderByItem(ItemStack stack, MatrixStack poseStack, IRenderTypeBuffer source, int packedLight) {
        AzBakedModel model = this.provider.provideBakedModel(stack);
        float partialTick = Minecraft.func_71410_x().func_184121_ak();
        ResourceLocation textureLocation = this.config.textureLocation(stack);
        RenderType renderType = this.rendererPipeline.context().getDefaultRenderType(stack, textureLocation, source, partialTick);
        boolean withGlint = stack != null && stack.func_77962_s();
        IVertexBuilder buffer = ItemRenderer.func_229113_a_((IRenderTypeBuffer)source, (RenderType)renderType, (boolean)false, (boolean)withGlint);
        this.prepareAnimator(stack, model);
        this.rendererPipeline.render(poseStack, model, stack, source, renderType, buffer, 0.0f, partialTick, packedLight);
    }

    private void prepareAnimator(ItemStack stack, AzBakedModel model) {
        AzItemAnimator cachedEntityAnimator = (AzItemAnimator)this.provider.provideAnimator(stack);
        if (cachedEntityAnimator != null && model != null) {
            cachedEntityAnimator.setActiveModel(model);
        }
        this.reusedAzItemAnimator = cachedEntityAnimator;
    }

    public AzItemAnimator getAnimator() {
        return this.reusedAzItemAnimator;
    }

    public AzItemRendererConfig config() {
        return this.config;
    }
}

