/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.layer;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.netty.util.internal.StringUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.AzArmorModel;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipeline;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererRegistry;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class AzArmorLayer<T extends LivingEntity>
implements AzRenderLayer<T> {
    protected static final Map<String, ResourceLocation> ARMOR_PATH_CACHE = new Object2ObjectOpenHashMap();
    protected static final BipedModel<LivingEntity> INNER_ARMOR_MODEL = new BipedModel(0.5f);
    protected static final BipedModel<LivingEntity> OUTER_ARMOR_MODEL = new BipedModel(1.0f);
    protected ItemStack mainHandStack;
    protected ItemStack offhandStack;
    protected ItemStack helmetStack;
    protected ItemStack chestplateStack;
    protected ItemStack leggingsStack;
    protected ItemStack bootsStack;

    @Override
    public void preRender(AzRendererPipelineContext<T> context) {
        this.mainHandStack = ((LivingEntity)context.animatable()).func_184582_a(EquipmentSlotType.MAINHAND);
        this.offhandStack = ((LivingEntity)context.animatable()).func_184582_a(EquipmentSlotType.OFFHAND);
        this.helmetStack = ((LivingEntity)context.animatable()).func_184582_a(EquipmentSlotType.HEAD);
        this.chestplateStack = ((LivingEntity)context.animatable()).func_184582_a(EquipmentSlotType.CHEST);
        this.leggingsStack = ((LivingEntity)context.animatable()).func_184582_a(EquipmentSlotType.LEGS);
        this.bootsStack = ((LivingEntity)context.animatable()).func_184582_a(EquipmentSlotType.FEET);
    }

    @Override
    public void render(AzRendererPipelineContext<T> context) {
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<T> context, AzBone bone) {
        ItemStack armorStack = this.getArmorItemForBone(context, bone);
        if (armorStack == null) {
            return;
        }
        if (armorStack.func_77973_b() instanceof BlockItem && ((BlockItem)armorStack.func_77973_b()).func_179223_d() instanceof AbstractSkullBlock) {
            AbstractSkullBlock skullBlock = (AbstractSkullBlock)((BlockItem)armorStack.func_77973_b()).func_179223_d();
            this.renderSkullAsArmor(context, bone, armorStack, skullBlock);
        } else {
            this.renderArmor(context, bone, armorStack);
        }
    }

    public void renderArmor(AzRendererPipelineContext<T> context, AzBone bone, ItemStack armorStack) {
        EquipmentSlotType slot = this.getEquipmentSlotForBone(context, bone, armorStack);
        AzArmorRenderer renderer = AzArmorRendererRegistry.getOrNull(armorStack.func_77973_b());
        BipedModel<T> model = this.getModelForItem(armorStack, slot);
        ModelRenderer modelPart = this.getModelPartForBone(context, bone, model);
        if (!modelPart.field_78804_l.isEmpty()) {
            context.poseStack().func_227860_a_();
            context.poseStack().func_227862_a_(-1.0f, -1.0f, 1.0f);
            if (renderer != null) {
                this.prepModelPartForRender(context, bone, modelPart);
                this.renderAzArmorPiece(context, slot, armorStack, renderer, (LivingEntity)context.animatable(), model, modelPart);
            } else if (armorStack.func_77973_b() instanceof ArmorItem) {
                this.prepModelPartForRender(context, bone, modelPart);
                this.renderVanillaArmorPiece(context, bone, slot, armorStack, modelPart);
            }
            context.poseStack().func_227865_b_();
        }
    }

    protected EquipmentSlotType getEquipmentSlotForBone(AzRendererPipelineContext<T> context, AzBone bone, ItemStack stack) {
        LivingEntity animatable = (LivingEntity)context.animatable();
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            boolean isHumanoidArmorSlotType;
            boolean bl = isHumanoidArmorSlotType = slot.func_188453_a() == EquipmentSlotType.Group.ARMOR;
            if (!isHumanoidArmorSlotType || stack != animatable.func_184582_a(slot)) continue;
            return slot;
        }
        return EquipmentSlotType.CHEST;
    }

    protected ModelRenderer getModelPartForBone(AzRendererPipelineContext<T> context, AzBone bone, BipedModel<?> baseModel) {
        return baseModel.field_78115_e;
    }

    protected ItemStack getArmorItemForBone(AzRendererPipelineContext<T> context, AzBone bone) {
        return null;
    }

    protected void renderAzArmorPiece(AzRendererPipelineContext<T> context, EquipmentSlotType slot, ItemStack armorStack, AzArmorRenderer renderer, LivingEntity entity, BipedModel<T> model, ModelRenderer modelPart) {
        AzArmorRendererPipeline renderPipelines = renderer.rendererPipeline();
        AzArmorBoneContext boneContext = renderPipelines.context().boneContext();
        AzArmorModel<?> armorModel = renderPipelines.armorModel();
        renderer.prepForRender((Entity)entity, armorStack, slot, model);
        boneContext.applyBoneVisibilityByPart(slot, modelPart, model);
        armorModel.func_225598_a_(context.poseStack(), null, context.packedLight(), OverlayTexture.field_229196_a_, context.red(), context.green(), context.blue(), context.alpha());
    }

    protected <I extends Item> void renderVanillaArmorPiece(AzRendererPipelineContext<T> context, AzBone bone, EquipmentSlotType slot, ItemStack armorStack, ModelRenderer modelPart) {
        IVertexBuilder buffer = this.getVanillaArmorBuffer(context, armorStack, slot, bone, false);
        modelPart.func_228308_a_(context.poseStack(), buffer, context.packedLight(), context.packedOverlay());
        if (armorStack.func_77962_s()) {
            modelPart.func_228309_a_(context.poseStack(), this.getVanillaArmorBuffer(context, armorStack, slot, bone, true), context.packedLight(), context.packedOverlay(), context.red(), context.green(), context.blue(), context.alpha());
        }
    }

    protected IVertexBuilder getVanillaArmorBuffer(AzRendererPipelineContext<T> context, ItemStack stack, EquipmentSlotType slot, AzBone bone, boolean forGlint) {
        if (forGlint) {
            return context.multiBufferSource().getBuffer(RenderType.func_228655_k_());
        }
        return context.multiBufferSource().getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getVanillaArmorResource((Entity)context.animatable(), stack, slot, bone.getName())));
    }

    protected AzArmorRenderer getRendererForItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        return AzArmorRendererRegistry.getOrNull(item);
    }

    protected BipedModel<T> getModelForItem(ItemStack stack, EquipmentSlotType slot) {
        AzArmorRenderer renderer = this.getRendererForItem(stack);
        if (renderer == null) {
            return slot == EquipmentSlotType.LEGS ? INNER_ARMOR_MODEL : OUTER_ARMOR_MODEL;
        }
        return renderer.rendererPipeline().armorModel();
    }

    protected void renderSkullAsArmor(AzRendererPipelineContext<T> context, AzBone bone, ItemStack stack, AbstractSkullBlock skullBlock) {
        GameProfile skullProfile = null;
        if (stack.func_77942_o()) {
            String s;
            CompoundNBT compoundnbt = stack.func_77978_p();
            if (compoundnbt.func_150297_b("SkullOwner", 10)) {
                skullProfile = NBTUtil.func_152459_a((CompoundNBT)compoundnbt.func_74775_l("SkullOwner"));
            } else if (compoundnbt.func_150297_b("SkullOwner", 8) && !StringUtil.isNullOrEmpty((String)(s = compoundnbt.func_74779_i("SkullOwner")))) {
                skullProfile = SkullTileEntity.func_174884_b((GameProfile)new GameProfile(null, s));
                compoundnbt.func_218657_a("SkullOwner", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)skullProfile));
            }
        }
        context.poseStack().func_227860_a_();
        RenderUtils.translateAndRotateMatrixForBone(context.poseStack(), bone);
        context.poseStack().func_227862_a_(1.1875f, 1.1875f, 1.1875f);
        context.poseStack().func_227861_a_(-0.5, 0.0, -0.5);
        SkullTileEntityRenderer.func_228879_a_((Direction)null, (float)0.0f, (SkullBlock.ISkullType)((AbstractSkullBlock)((BlockItem)stack.func_77973_b()).func_179223_d()).func_196292_N_(), (GameProfile)skullProfile, (float)0.0f, (MatrixStack)context.poseStack(), (IRenderTypeBuffer)context.multiBufferSource(), (int)context.packedLight());
        context.poseStack().func_227865_b_();
    }

    protected void prepModelPartForRender(AzRendererPipelineContext<T> context, AzBone bone, ModelRenderer sourcePart) {
        GeoCube firstCube = bone.getCubes().get(0);
        ModelRenderer.ModelBox armorCube = (ModelRenderer.ModelBox)sourcePart.field_78804_l.get(0);
        double armorBoneSizeX = firstCube.size().func_82615_a();
        double armorBoneSizeY = firstCube.size().func_82617_b();
        double armorBoneSizeZ = firstCube.size().func_82616_c();
        float actualArmorSizeX = Math.abs(armorCube.field_78248_d - armorCube.field_78252_a);
        float actualArmorSizeY = Math.abs(armorCube.field_78249_e - armorCube.field_78250_b);
        float actualArmorSizeZ = Math.abs(armorCube.field_78246_f - armorCube.field_78251_c);
        float scaleX = (float)(armorBoneSizeX / (double)actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / (double)actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / (double)actualArmorSizeZ);
        sourcePart.func_78793_a(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        sourcePart.field_78795_f = -bone.getRotX();
        sourcePart.field_78796_g = -bone.getRotY();
        sourcePart.field_78808_h = bone.getRotZ();
        context.poseStack().func_227862_a_(scaleX, scaleY, scaleZ);
    }

    public ResourceLocation getVanillaArmorResource(Entity entity, ItemStack stack, EquipmentSlotType slot, String type) {
        String domain = "minecraft";
        String path = ((ArmorItem)stack.func_77973_b()).func_200880_d().func_200897_d();
        String[] materialNameSplit = path.split(":", 2);
        if (materialNameSplit.length > 1) {
            domain = materialNameSplit[0];
            path = materialNameSplit[1];
        }
        if (!type.isEmpty()) {
            type = "_" + type;
        }
        String texture = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, path, slot == EquipmentSlotType.LEGS ? 2 : 1, type);
        return ARMOR_PATH_CACHE.computeIfAbsent(texture, ResourceLocation::new);
    }
}

