/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.layer;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import mod.azure.azurelib.cache.texture.AutoGlowingTexture;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import mod.azure.azurelib.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class AzAutoGlowingLayer<T>
implements AzRenderLayer<T> {
    @Override
    public void preRender(AzRendererPipelineContext<T> context) {
    }

    @Override
    public void render(AzRendererPipelineContext<T> context) {
        T animatable = context.animatable();
        AzRendererPipeline<T> renderPipeline = context.rendererPipeline();
        ResourceLocation textureLocation = renderPipeline.config().textureLocation(animatable);
        RenderType renderType = AutoGlowingTexture.getRenderType(textureLocation);
        if (context.animatable() instanceof Entity) {
            Entity entity = (Entity)context.animatable();
            boolean isInvisibleButVisibleToPlayer = entity.func_82150_aj() && !entity.func_98034_c(ClientUtils.getClientPlayer());
            boolean shouldAppearGlowing = Minecraft.func_71410_x().field_147125_j.func_225510_bt_();
            if (isInvisibleButVisibleToPlayer) {
                renderType = RenderType.func_228654_j_((ResourceLocation)textureLocation);
            } else if (shouldAppearGlowing) {
                renderType = AutoGlowingTexture.getOutlineRenderType(textureLocation);
            }
        }
        if (context.renderType() != null) {
            RenderType prevRenderType = context.renderType();
            int prevPackedLight = context.packedLight();
            IVertexBuilder prevVertexConsumer = context.vertexConsumer();
            context.setRenderType(renderType);
            context.setPackedLight(0xF00000);
            context.setVertexConsumer(context.multiBufferSource().getBuffer(renderType));
            renderPipeline.reRender(context);
            context.setRenderType(prevRenderType);
            context.setPackedLight(prevPackedLight);
            context.setVertexConsumer(prevVertexConsumer);
        }
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<T> context, AzBone bone) {
    }
}

