/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.layer;

import java.util.function.Function;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;

public class AzBlockAndItemLayer<T>
implements AzRenderLayer<T> {
    protected final Function<AzBone, ItemStack> itemStackProvider;
    protected final Function<AzBone, BlockState> blockStateProvider;

    public AzBlockAndItemLayer() {
        this(bone -> null, bone -> null);
    }

    public AzBlockAndItemLayer(Function<AzBone, ItemStack> itemStackProvider, Function<AzBone, BlockState> blockStateProvider) {
        this.itemStackProvider = itemStackProvider;
        this.blockStateProvider = blockStateProvider;
    }

    @Override
    public void preRender(AzRendererPipelineContext<T> context) {
    }

    @Override
    public void render(AzRendererPipelineContext<T> context) {
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<T> context, AzBone bone) {
        T animatable = context.animatable();
        ItemStack stack = this.itemStackForBone(bone, animatable);
        BlockState blockState = this.blockStateForBone(bone, animatable);
        if (stack == null && blockState == null) {
            return;
        }
        context.poseStack().func_227860_a_();
        RenderUtils.translateAndRotateMatrixForBone(context.poseStack(), bone);
        if (stack != null) {
            this.renderItemForBone(context, bone, stack, animatable);
        }
        if (blockState != null) {
            this.renderBlockForBone(context, bone, blockState, animatable);
        }
        context.poseStack().func_227865_b_();
    }

    public ItemStack itemStackForBone(AzBone bone, T animatable) {
        return this.itemStackProvider.apply(bone);
    }

    public BlockState blockStateForBone(AzBone bone, T animatable) {
        return this.blockStateProvider.apply(bone);
    }

    protected ItemCameraTransforms.TransformType getTransformTypeForStack(AzBone bone, ItemStack stack, T animatable) {
        return ItemCameraTransforms.TransformType.NONE;
    }

    protected void renderItemForBone(AzRendererPipelineContext<T> context, AzBone bone, ItemStack itemStack, T animatable) {
        if (context.animatable() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)context.animatable();
            Minecraft.func_71410_x().func_175599_af().func_229109_a_(livingEntity, itemStack, this.getTransformTypeForStack(bone, itemStack, animatable), false, context.poseStack(), context.multiBufferSource(), livingEntity.field_70170_p, context.packedLight(), context.packedOverlay());
        } else {
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemStack, this.getTransformTypeForStack(bone, itemStack, animatable), context.packedLight(), context.packedOverlay(), context.poseStack(), context.multiBufferSource());
        }
    }

    protected void renderBlockForBone(AzRendererPipelineContext<T> context, AzBone bone, BlockState blockState, T animatable) {
        context.poseStack().func_227860_a_();
        context.poseStack().func_227861_a_(-0.25, -0.25, -0.25);
        context.poseStack().func_227862_a_(0.5f, 0.5f, 0.5f);
        Minecraft.func_71410_x().func_175602_ab().func_228791_a_(blockState, context.poseStack(), context.multiBufferSource(), context.packedLight(), OverlayTexture.field_229196_a_);
        context.poseStack().func_227865_b_();
    }
}

