/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.util.codec;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;

public class AzListStreamCodec<T> {
    private final Function<PacketBuffer, T> decoder;
    private final BiConsumer<PacketBuffer, T> encoder;

    public AzListStreamCodec(Function<PacketBuffer, T> decoder, BiConsumer<PacketBuffer, T> encoder) {
        this.decoder = decoder;
        this.encoder = encoder;
    }

    public List<T> decode(PacketBuffer buf) {
        int size = buf.readByte();
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.decoder.apply(buf));
        }
        return list;
    }

    public void encode(PacketBuffer buf, List<T> elements) {
        buf.writeByte(elements.size());
        elements.forEach(element -> this.encoder.accept(buf, (PacketBuffer)element));
    }
}

