/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.loading.json.raw.Bone;
import mod.azure.azurelib.loading.json.raw.Cube;
import mod.azure.azurelib.loading.json.raw.FaceUV;
import mod.azure.azurelib.loading.json.raw.LocatorClass;
import mod.azure.azurelib.loading.json.raw.LocatorValue;
import mod.azure.azurelib.loading.json.raw.MinecraftGeometry;
import mod.azure.azurelib.loading.json.raw.Model;
import mod.azure.azurelib.loading.json.raw.ModelProperties;
import mod.azure.azurelib.loading.json.raw.PolyMesh;
import mod.azure.azurelib.loading.json.raw.PolysUnion;
import mod.azure.azurelib.loading.json.raw.TextureMesh;
import mod.azure.azurelib.loading.json.raw.UVFaces;
import mod.azure.azurelib.loading.json.raw.UVUnion;
import mod.azure.azurelib.loading.json.typeadapter.BakedAnimationsAdapter;
import mod.azure.azurelib.loading.json.typeadapter.KeyFramesAdapter;
import mod.azure.azurelib.loading.object.BakedAnimations;
import mod.azure.azurelib.rewrite.animation.parse.AzBakedAnimationsAdapter;
import mod.azure.azurelib.rewrite.animation.parse.AzKeyframesAdapter;
import mod.azure.azurelib.rewrite.animation.primitive.AzBakedAnimations;
import mod.azure.azurelib.rewrite.animation.primitive.AzKeyframes;
import net.minecraft.util.JSONUtils;

public final class JsonUtil {
    public static final Gson GEO_GSON = new GsonBuilder().setLenient().registerTypeAdapter(Bone.class, Bone.deserializer()).registerTypeAdapter(Cube.class, Cube.deserializer()).registerTypeAdapter(FaceUV.class, FaceUV.deserializer()).registerTypeAdapter(LocatorClass.class, LocatorClass.deserializer()).registerTypeAdapter(LocatorValue.class, LocatorValue.deserializer()).registerTypeAdapter(MinecraftGeometry.class, MinecraftGeometry.deserializer()).registerTypeAdapter(Model.class, Model.deserializer()).registerTypeAdapter(ModelProperties.class, ModelProperties.deserializer()).registerTypeAdapter(PolyMesh.class, PolyMesh.deserializer()).registerTypeAdapter(PolysUnion.class, PolysUnion.deserializer()).registerTypeAdapter(TextureMesh.class, TextureMesh.deserializer()).registerTypeAdapter(UVFaces.class, UVFaces.deserializer()).registerTypeAdapter(UVUnion.class, UVUnion.deserializer()).registerTypeAdapter(Animation.Keyframes.class, (Object)new KeyFramesAdapter()).registerTypeAdapter(BakedAnimations.class, (Object)new BakedAnimationsAdapter()).registerTypeAdapter(AzKeyframes.class, (Object)new AzKeyframesAdapter()).registerTypeAdapter(AzBakedAnimations.class, (Object)new AzBakedAnimationsAdapter()).create();

    public static double[] jsonArrayToDoubleArray(@Nullable JsonArray array) throws JsonParseException {
        if (array == null) {
            return new double[3];
        }
        double[] output = new double[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            output[i] = array.get(i).getAsDouble();
        }
        return output;
    }

    public static <T> T[] jsonArrayToObjectArray(JsonArray array, JsonDeserializationContext context, Class<T> objectClass) {
        Object[] objArray = (Object[])Array.newInstance(objectClass, array.size());
        for (int i = 0; i < array.size(); ++i) {
            objArray[i] = context.deserialize(array.get(i), objectClass);
        }
        return objArray;
    }

    public static <T> List<T> jsonArrayToList(@Nullable JsonArray array, Function<JsonElement, T> elementTransformer) {
        if (array == null) {
            return new ObjectArrayList();
        }
        ObjectArrayList list = new ObjectArrayList(array.size());
        for (JsonElement element : array) {
            list.add(elementTransformer.apply(element));
        }
        return list;
    }

    public static <T> Map<String, T> jsonObjToMap(JsonObject obj, JsonDeserializationContext context, Class<T> objectType) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(obj.size());
        for (Map.Entry entry : obj.entrySet()) {
            map.put(entry.getKey(), context.deserialize((JsonElement)entry.getValue(), objectType));
        }
        return map;
    }

    @Nullable
    public static Long getOptionalLong(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Long.valueOf(JSONUtils.func_226161_m_((JsonObject)obj, (String)elementName)) : null;
    }

    @Nullable
    public static Boolean getOptionalBoolean(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Boolean.valueOf(JSONUtils.func_151212_i((JsonObject)obj, (String)elementName)) : null;
    }

    @Nullable
    public static Double getOptionalDouble(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Double.valueOf(JsonUtil.getAsDouble(obj, elementName)) : null;
    }

    @Nullable
    public static Float getOptionalFloat(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Float.valueOf(JSONUtils.func_151217_k((JsonObject)obj, (String)elementName)) : null;
    }

    @Nullable
    public static Integer getOptionalInteger(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Integer.valueOf(JSONUtils.func_151203_m((JsonObject)obj, (String)elementName)) : null;
    }

    public static double convertToDouble(JsonElement jsonElement, String string) {
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return jsonElement.getAsDouble();
        }
        throw new JsonSyntaxException("Expected " + string + " to be a Double, was " + JSONUtils.func_151222_d((JsonElement)jsonElement));
    }

    public static double getAsDouble(JsonObject jsonObject, String string) {
        if (jsonObject.has(string)) {
            return JsonUtil.convertToDouble(jsonObject.get(string), string);
        }
        throw new JsonSyntaxException("Missing " + string + ", expected to find a Double");
    }
}

