/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.InputStream;
import javax.annotation.Nullable;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.renderer.GeoArmorRenderer;
import mod.azure.azurelib.renderer.GeoRenderer;
import mod.azure.azurelib.renderer.GeoReplacedEntityRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.util.NativeUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public final class RenderUtils {
    public static void copy(Matrix4f main, Matrix4f other) {
        main.field_226575_a_ = other.field_226575_a_;
        main.field_226576_b_ = other.field_226576_b_;
        main.field_226577_c_ = other.field_226577_c_;
        main.field_226578_d_ = other.field_226578_d_;
        main.field_226579_e_ = other.field_226579_e_;
        main.field_226580_f_ = other.field_226580_f_;
        main.field_226581_g_ = other.field_226581_g_;
        main.field_226582_h_ = other.field_226582_h_;
        main.field_226583_i_ = other.field_226583_i_;
        main.field_226584_j_ = other.field_226584_j_;
        main.field_226585_k_ = other.field_226585_k_;
        main.field_226586_l_ = other.field_226586_l_;
        main.field_226587_m_ = other.field_226587_m_;
        main.field_226588_n_ = other.field_226588_n_;
        main.field_226589_o_ = other.field_226589_o_;
        main.field_226590_p_ = other.field_226590_p_;
    }

    public static void translateMatrixToBone(MatrixStack poseStack, CoreGeoBone bone) {
        poseStack.func_227861_a_((double)(-bone.getPosX() / 16.0f), (double)(bone.getPosY() / 16.0f), (double)(bone.getPosZ() / 16.0f));
    }

    public static void rotateMatrixAroundBone(MatrixStack poseStack, CoreGeoBone bone) {
        if (bone.getRotZ() != 0.0f) {
            poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(bone.getRotZ()));
        }
        if (bone.getRotY() != 0.0f) {
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(bone.getRotY()));
        }
        if (bone.getRotX() != 0.0f) {
            poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(bone.getRotX()));
        }
    }

    public static void rotateMatrixAroundCube(MatrixStack poseStack, GeoCube cube) {
        Vec3d rotation = cube.rotation();
        poseStack.func_227863_a_(new Quaternion(0.0f, 0.0f, (float)rotation.field_72449_c, false));
        poseStack.func_227863_a_(new Quaternion(0.0f, (float)rotation.field_72448_b, 0.0f, false));
        poseStack.func_227863_a_(new Quaternion((float)rotation.field_72450_a, 0.0f, 0.0f, false));
    }

    public static void scaleMatrixForBone(MatrixStack poseStack, CoreGeoBone bone) {
        poseStack.func_227862_a_(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(MatrixStack poseStack, GeoCube cube) {
        Vec3d pivot = cube.pivot();
        poseStack.func_227861_a_(pivot.field_72450_a / 16.0, pivot.field_72448_b / 16.0, pivot.field_72449_c / 16.0);
    }

    public static void translateToPivotPoint(MatrixStack poseStack, CoreGeoBone bone) {
        poseStack.func_227861_a_((double)(bone.getPivotX() / 16.0f), (double)(bone.getPivotY() / 16.0f), (double)(bone.getPivotZ() / 16.0f));
    }

    public static void translateAwayFromPivotPoint(MatrixStack poseStack, GeoCube cube) {
        Vec3d pivot = cube.pivot();
        poseStack.func_227861_a_(-pivot.field_72450_a / 16.0, -pivot.field_72448_b / 16.0, -pivot.field_72449_c / 16.0);
    }

    public static void translateAwayFromPivotPoint(MatrixStack poseStack, CoreGeoBone bone) {
        poseStack.func_227861_a_((double)(-bone.getPivotX() / 16.0f), (double)(-bone.getPivotY() / 16.0f), (double)(-bone.getPivotZ() / 16.0f));
    }

    public static void translateAndRotateMatrixForBone(MatrixStack poseStack, CoreGeoBone bone) {
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
    }

    public static void prepMatrixForBone(MatrixStack poseStack, CoreGeoBone bone) {
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
    }

    public static Matrix4f invertAndMultiplyMatrices(Matrix4f baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = new Matrix4f(inputMatrix);
        inputMatrix.func_226600_c_();
        inputMatrix.func_226595_a_(baseMatrix);
        return inputMatrix;
    }

    public static void faceRotation(MatrixStack poseStack, Entity animatable, float partialTick) {
        poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219799_g((float)partialTick, (float)animatable.field_70126_B, (float)animatable.field_70177_z) - 90.0f));
        poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_219799_g((float)partialTick, (float)animatable.field_70127_C, (float)animatable.field_70125_A)));
    }

    @Nullable
    public static Tuple<Integer, Integer> getTextureDimensions(ResourceLocation texture) {
        if (texture == null) {
            return null;
        }
        Texture originalTexture = null;
        Minecraft mc = Minecraft.func_71410_x();
        try {
            originalTexture = (Texture)mc.func_213169_a(() -> mc.func_110434_K().func_229267_b_(texture)).get();
        }
        catch (Exception e) {
            AzureLib.LOGGER.warn("Failed to load image for id {}", (Object)texture);
            e.printStackTrace();
        }
        if (originalTexture == null) {
            return null;
        }
        NativeImage image = null;
        try {
            image = originalTexture instanceof DynamicTexture ? ((DynamicTexture)originalTexture).func_195414_e() : NativeImage.func_195713_a((InputStream)mc.func_195551_G().func_199002_a(texture).func_199027_b());
        }
        catch (Exception e) {
            AzureLib.LOGGER.error("Failed to read image for id {}", (Object)texture);
            e.printStackTrace();
        }
        return image == null ? null : new Tuple((Object)image.func_195702_a(), (Object)image.func_195714_b());
    }

    public static double getCurrentSystemTick() {
        return (double)System.nanoTime() / 1000000.0 / 50.0;
    }

    public static double getCurrentTick() {
        return NativeUtil.func_216394_b() * 20.0;
    }

    public static float booleanToFloat(boolean input) {
        return input ? 1.0f : 0.0f;
    }

    public static Vec3d arrayToVec(double[] array) {
        return new Vec3d(array[0], array[1], array[2]);
    }

    public static void matchModelPartRot(ModelRenderer from, CoreGeoBone to) {
        to.updateRotation(-from.field_78795_f, -from.field_78796_g, from.field_78808_h);
    }

    public static void fixInvertedFlatCube(GeoCube cube, Vector3f normal) {
        if (normal.func_195899_a() < 0.0f && (cube.size().field_72448_b == 0.0 || cube.size().field_72449_c == 0.0)) {
            normal.func_229192_b_(-1.0f, 1.0f, 1.0f);
        }
        if (normal.func_195900_b() < 0.0f && (cube.size().field_72450_a == 0.0 || cube.size().field_72449_c == 0.0)) {
            normal.func_229192_b_(1.0f, -1.0f, 1.0f);
        }
        if (normal.func_195902_c() < 0.0f && (cube.size().field_72450_a == 0.0 || cube.size().field_72448_b == 0.0)) {
            normal.func_229192_b_(1.0f, 1.0f, -1.0f);
        }
    }

    public static float getDirectionAngle(Direction direction) {
        if (direction.equals((Object)Direction.NORTH)) {
            return 270.0f;
        }
        if (direction.equals((Object)Direction.SOUTH)) {
            return 90.0f;
        }
        if (direction.equals((Object)Direction.EAST)) {
            return 180.0f;
        }
        return 0.0f;
    }

    @Deprecated
    @Nullable
    public static GeoModel<?> getGeoModelForEntityType(EntityType<?> entityType) {
        EntityRenderer renderer = (EntityRenderer)Minecraft.func_71410_x().func_175598_ae().field_78729_o.get(entityType);
        return renderer instanceof GeoRenderer ? ((GeoRenderer)renderer).getGeoModel() : null;
    }

    @Deprecated
    @Nullable
    public static GeoAnimatable getReplacedAnimatable(EntityType<?> entityType) {
        EntityRenderer renderer = (EntityRenderer)Minecraft.func_71410_x().func_175598_ae().field_78729_o.get(entityType);
        return renderer instanceof GeoReplacedEntityRenderer ? (GeoAnimatable)((GeoReplacedEntityRenderer)renderer).getAnimatable() : null;
    }

    @Deprecated
    @Nullable
    public static GeoModel<?> getGeoModelForEntity(Entity entity) {
        EntityRenderer renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity);
        return renderer instanceof GeoRenderer ? ((GeoRenderer)renderer).getGeoModel() : null;
    }

    @Deprecated
    @Nullable
    public static GeoModel<?> getGeoModelForItem(Item item) {
        if (item.getItemStackTileEntityRenderer() instanceof GeoRenderer) {
            return ((GeoRenderer)item.getItemStackTileEntityRenderer()).getGeoModel();
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static GeoModel<?> getGeoModelForBlock(TileEntity blockEntity) {
        TileEntityRenderer renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(blockEntity);
        return renderer instanceof GeoRenderer ? ((GeoRenderer)renderer).getGeoModel() : null;
    }

    @Deprecated
    @Nullable
    public static GeoModel<?> getGeoModelForArmor(ItemStack stack) {
        if (stack.func_77973_b().getArmorModel(null, stack, null, null) instanceof GeoArmorRenderer) {
            return ((GeoArmorRenderer)stack.func_77973_b().getArmorModel(null, stack, null, null)).getGeoModel();
        }
        return null;
    }
}

