/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.client.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class DialogScreen
extends class_437 {
    public static final class_2561 TEXT_CONFIRM = class_2561.method_43471((String)"text.azurelib.screen.dialog.confirm");
    public static final class_2561 TEXT_CANCEL = class_2561.method_43471((String)"text.azurelib.screen.dialog.cancel");
    private final class_437 background;
    private DialogRespondEvent onCancel;
    private DialogRespondEvent onConfirm;
    protected final class_2561[] text;
    protected int dialogWidth;
    protected int dialogHeight;
    protected int dialogLeft;
    protected int dialogTop;
    private List<class_5481> splitText = new ArrayList<class_5481>();

    public DialogScreen(class_2561 title, class_2561[] text, class_437 background) {
        super(title);
        this.text = text;
        this.background = background;
        this.onCancel = this::displayPreviousScreen;
        this.onConfirm = this::displayPreviousScreen;
    }

    public void onCancelled(DialogRespondEvent cancelEvent) {
        this.onCancel = Objects.requireNonNull(cancelEvent);
    }

    public void onConfirmed(DialogRespondEvent confirmEvent) {
        this.onConfirm = Objects.requireNonNull(confirmEvent);
    }

    public void setDimensions(int dialogWidth, int dialogHeight) {
        this.dialogWidth = dialogWidth;
        this.dialogHeight = dialogHeight;
        this.dialogLeft = (this.field_22789 - this.dialogWidth) / 2;
        this.dialogTop = (this.field_22790 - this.dialogHeight) / 2;
        this.splitText = Arrays.stream(this.text).map(line -> this.field_22793.method_1728((class_5348)line, this.dialogWidth - 10)).flatMap(Collection::stream).toList();
    }

    protected void method_25426() {
        this.background.method_25423(this.field_22787, this.field_22789, this.field_22790);
        this.setDimensions(140, 100);
        this.addDefaultDialogButtons();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int backgroundColor = -16777216;
        this.background.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        graphics.method_25296(this.dialogLeft - 1, this.dialogTop - 1, this.dialogLeft + this.dialogWidth + 1, this.dialogTop + this.dialogHeight + 1, -1, -1);
        graphics.method_25296(this.dialogLeft, this.dialogTop, this.dialogLeft + this.dialogWidth, this.dialogTop + this.dialogHeight, backgroundColor, backgroundColor);
        this.renderForeground(graphics, mouseX, mouseY, partialTicks);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_51448().method_22909();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.allowKeyboardInteractions()) {
            if (keyCode == 256) {
                this.cancel();
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.confirm();
                return true;
            }
            return false;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int headerWidth = this.field_22793.method_27525((class_5348)this.field_22785);
        graphics.method_51439(this.field_22793, this.field_22785, (int)((float)this.dialogLeft + (float)(this.dialogWidth - headerWidth) / 2.0f), this.dialogTop + 5, 0xFFFFFF, true);
        int line = 0;
        for (class_5481 textLine : this.splitText) {
            graphics.method_51430(this.field_22793, textLine, this.dialogLeft + 5, this.dialogTop + 20 + line * 10, 0xFFFFFF, true);
            ++line;
        }
    }

    protected void addDefaultDialogButtons() {
        int useableWidth = this.dialogWidth - 15;
        int componentWidth = useableWidth / 2;
        int cancelX = this.dialogLeft + 5;
        int confirmX = this.dialogLeft + this.dialogWidth - 5 - componentWidth;
        int componentY = this.dialogTop + this.dialogHeight - 25;
        this.method_37063((class_364)class_4185.method_46430((class_2561)TEXT_CANCEL, btn -> this.cancel()).method_46433(cancelX, componentY).method_46437(componentWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)TEXT_CONFIRM, btn -> this.confirm()).method_46433(confirmX, componentY).method_46437(componentWidth, 20).method_46431());
    }

    protected void confirm() {
        this.onConfirm.respond(this);
    }

    protected void cancel() {
        this.onCancel.respond(this);
    }

    public void displayPreviousScreen(DialogScreen screen) {
        this.field_22787.method_1507(this.background);
    }

    protected boolean allowKeyboardInteractions() {
        return true;
    }

    @FunctionalInterface
    public static interface DialogRespondEvent {
        public void respond(DialogScreen var1);
    }
}

