/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.client.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mod.azure.azurelib.client.screen.DialogScreen;
import mod.azure.azurelib.config.Configurable;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6382;

public final class ColorWidget
extends class_339 {
    public static final class_2561 SELECT_COLOR = class_2561.method_43471((String)"text.azurelib.screen.color_dialog");
    private final boolean argb;
    private final String colorPrefix;
    private final IntSupplier colorSupplier;
    private final GetSet<String> colorWidget;
    private final class_437 lastScreen;

    public ColorWidget(int x, int y, int width, int height, Configurable.Gui.ColorValue colorOptions, GetSet<String> colorWidget, class_437 lastScreen) {
        super(x, y, width, height, class_5244.field_39003);
        this.argb = colorOptions.isARGB();
        this.colorPrefix = colorOptions.getGuiColorPrefix();
        this.colorWidget = colorWidget;
        this.colorSupplier = () -> {
            String rawColor = (String)colorWidget.get();
            try {
                long longClr = Long.decode(rawColor);
                return (int)longClr;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        };
        this.lastScreen = lastScreen;
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialRenderTicks) {
        int borderColor = this.method_25370() ? -1 : -6250336;
        int providedColor = this.colorSupplier.getAsInt();
        int color = this.argb ? providedColor : 0xFF000000 | providedColor;
        graphics.method_25294(this.method_46426() - 1, this.method_46427() - 1, this.method_46426() + this.field_22758 + 1, this.method_46427() + this.field_22759 + 1, borderColor);
        graphics.method_25296(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -1, -7829368);
        graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, color);
    }

    protected boolean method_25351(int button) {
        return button == 0;
    }

    public void method_25348(double mouseX, double mouseY) {
        ColorSelectorDialog dialog = new ColorSelectorDialog(SELECT_COLOR, this.lastScreen, this.argb, this.colorSupplier);
        dialog.onConfirmed(screen -> {
            int color = dialog.getResultColor();
            String colorText = this.colorPrefix + Integer.toHexString(color).toUpperCase(Locale.ROOT);
            this.colorWidget.set(colorText);
            dialog.displayPreviousScreen(dialog);
        });
        class_310.method_1551().method_1507((class_437)dialog);
    }

    public void method_47399(class_6382 elementOutput) {
    }

    public static interface GetSet<T> {
        public T get();

        public void set(T var1);

        public static <T> GetSet<T> of(final Supplier<T> get, final Consumer<T> set) {
            return new GetSet<T>(){

                @Override
                public T get() {
                    return get.get();
                }

                @Override
                public void set(T t) {
                    set.accept(t);
                }
            };
        }
    }

    private static final class ColorSelectorDialog
    extends DialogScreen {
        private final boolean argb;
        private final IntSupplier colorProvider;
        private final List<ColorSlider> sliders = new ArrayList<ColorSlider>();

        public ColorSelectorDialog(class_2561 title, class_437 background, boolean allowTransparency, IntSupplier colorProvider) {
            super(title, new class_2561[0], background);
            this.argb = allowTransparency;
            this.colorProvider = colorProvider;
        }

        @Override
        protected void method_25426() {
            this.sliders.clear();
            int width = 190;
            int height = 120;
            int rightMargin = 85;
            if (this.argb) {
                height = 150;
                rightMargin = 110;
                width = 230;
            }
            super.method_25426();
            this.setDimensions(width, height);
            int color = this.colorProvider.getAsInt();
            this.sliders.add((ColorSlider)this.method_37063((class_364)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 20, this.dialogWidth - rightMargin, 20, color, ColorComponent.RED)));
            this.sliders.add((ColorSlider)this.method_37063((class_364)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 45, this.dialogWidth - rightMargin, 20, color, ColorComponent.GREEN)));
            this.sliders.add((ColorSlider)this.method_37063((class_364)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 70, this.dialogWidth - rightMargin, 20, color, ColorComponent.BLUE)));
            if (this.argb) {
                this.sliders.add((ColorSlider)this.method_37063((class_364)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 95, this.dialogWidth - rightMargin, 20, color, ColorComponent.ALPHA)));
            }
            this.method_37063((class_364)new ColorDisplay(this.dialogLeft + 5 + this.dialogWidth - rightMargin + 5, this.dialogTop + 20, rightMargin - 15, rightMargin - 15, this.argb, this::getResultColor));
            super.addDefaultDialogButtons();
        }

        @Override
        protected void addDefaultDialogButtons() {
        }

        public int getResultColor() {
            int color = 0;
            for (ColorSlider slider : this.sliders) {
                color |= slider.getColor();
            }
            return color;
        }

        private static final class ColorSlider
        extends class_357 {
            private final ColorComponent colorComponent;

            public ColorSlider(int x, int y, int width, int height, int color, ColorComponent colorComponent) {
                super(x, y, width, height, class_5244.field_39003, (double)colorComponent.getByteColor(color) / 255.0);
                this.colorComponent = colorComponent;
                this.method_25346();
            }

            protected void method_25346() {
                class_2561 colorLabel = this.colorComponent.updateTitle(this.field_22753);
                this.method_25355(colorLabel);
            }

            protected void method_25344() {
            }

            int getColor() {
                return this.colorComponent.getOffsetColor((int)(255.0 * this.field_22753));
            }
        }

        private static enum ColorComponent {
            ALPHA(24),
            RED(16),
            GREEN(8),
            BLUE(0);

            private final int bitOffset;
            private final Function<Double, class_2561> title;

            private ColorComponent(int bitOffset) {
                this.bitOffset = bitOffset;
                this.title = val -> {
                    String name = this.name().toLowerCase(Locale.ROOT);
                    String translate = "text.azurelib.screen.color." + name;
                    int colorValue = (int)(val * 255.0);
                    return class_2561.method_43469((String)translate, (Object[])new Object[]{colorValue});
                };
            }

            public int getOffsetColor(int value) {
                return value << this.bitOffset;
            }

            public int getByteColor(int value) {
                return value >> this.bitOffset & 0xFF;
            }

            public class_2561 updateTitle(double sliderValue) {
                return this.title.apply(sliderValue);
            }
        }

        private static final class ColorDisplay
        extends class_339 {
            private final boolean argb;
            private final IntSupplier colorProvider;

            public ColorDisplay(int x, int y, int width, int height, boolean argb, IntSupplier colorProvider) {
                super(x, y, width, height, class_5244.field_39003);
                this.argb = argb;
                this.colorProvider = colorProvider;
            }

            public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
                int color = this.colorProvider.getAsInt();
                if (!this.argb) {
                    color |= 0xFF000000;
                }
                int borderColor = -6250336;
                graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, borderColor);
                graphics.method_25296(this.method_46426() + 1, this.method_46427() + 1, this.method_46426() + this.field_22758 - 1, this.method_46427() + this.field_22759 - 1, -1, -7829368);
                graphics.method_25294(this.method_46426() + 1, this.method_46427() + 1, this.method_46426() + this.field_22758 - 1, this.method_46427() + this.field_22759 - 1, color);
            }

            protected boolean method_25351(int button) {
                return false;
            }

            public void method_47399(class_6382 p_169152_) {
            }
        }
    }
}

