/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.cache.object.GeoQuad;
import mod.azure.azurelib.cache.object.GeoVertex;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4618;
import net.minecraft.class_4720;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class AzModelRenderer<T> {
    private final Matrix4f poseStateCache = new Matrix4f();
    private final Vector3f normalCache = new Vector3f();
    private final AzRendererPipeline<T> rendererPipeline;
    protected final AzLayerRenderer<T> layerRenderer;

    public AzModelRenderer(AzRendererPipeline<T> rendererPipeline, AzLayerRenderer<T> layerRenderer) {
        this.layerRenderer = layerRenderer;
        this.rendererPipeline = rendererPipeline;
    }

    protected void render(AzRendererPipelineContext<T> context, boolean isReRender) {
        T animatable = context.animatable();
        AzBakedModel model = context.bakedModel();
        this.rendererPipeline.updateAnimatedTextureFrame(animatable);
        for (AzBone bone : model.getTopLevelBones()) {
            this.renderRecursively(context, bone, isReRender);
        }
        AzRendererConfig<T> config = this.rendererPipeline.config();
        config.renderEntry(context);
    }

    protected void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        class_4587 poseStack = context.poseStack();
        poseStack.method_22903();
        RenderUtils.prepMatrixForBone(poseStack, bone);
        context.setVertexConsumer(this.getOrRefreshRenderBuffer(isReRender, context));
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.method_22909();
    }

    protected void renderCubesOfBone(AzRendererPipelineContext<T> context, AzBone bone) {
        if (bone.isHidden()) {
            return;
        }
        class_4587 poseStack = context.poseStack();
        for (GeoCube cube : bone.getCubes()) {
            poseStack.method_22903();
            this.renderCube(context, cube);
            poseStack.method_22909();
        }
    }

    protected void renderChildBones(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (AzBone childBone : bone.getChildBones()) {
            this.renderRecursively(context, childBone, isReRender);
        }
    }

    protected void renderCube(AzRendererPipelineContext<T> context, GeoCube cube) {
        class_4587 poseStack = context.poseStack();
        RenderUtils.translateToPivotPoint(poseStack, cube);
        RenderUtils.rotateMatrixAroundCube(poseStack, cube);
        RenderUtils.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.method_23760().method_23762();
        Matrix4f poseState = this.poseStateCache.set((Matrix4fc)poseStack.method_23760().method_23761());
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            RenderUtils.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(context, quad, poseState, normal);
        }
    }

    protected void createVerticesOfQuad(AzRendererPipelineContext<T> context, GeoQuad quad, Matrix4f poseState, Vector3f normal) {
        class_4588 buffer = context.vertexConsumer();
        int packedOverlay = context.packedOverlay();
        int packedLight = context.packedLight();
        for (GeoVertex vertex : quad.vertices()) {
            Vector3f position = vertex.position();
            Vector4f vector4f = poseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
            buffer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), context.red(), context.green(), context.blue(), context.alpha(), vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }

    public boolean boneRenderOverride(class_4587 poseStack, AzBone bone, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        return false;
    }

    @Nullable
    public class_1921 getRenderTypeOverrideForBone(AzBone bone, T animatable, class_2960 texturePath, class_4597 bufferSource, float partialTick) {
        return null;
    }

    @Nullable
    public class_2960 getTextureOverrideForBone(AzBone bone, T animatable, float partialTick) {
        return null;
    }

    public void handleAnimation(AzAnimator<T> animator, T animatable, float partialTick) {
        animator.animate(animatable, partialTick);
    }

    public class_4588 getOrRefreshRenderBuffer(boolean isReRender, AzRendererPipelineContext<T> context) {
        class_4588 currentBuffer = context.vertexConsumer();
        class_4597 bufferSource = context.multiBufferSource();
        class_1921 renderType = context.renderType();
        if (isReRender) {
            return currentBuffer;
        }
        if (currentBuffer instanceof class_287) {
            class_287 builder = (class_287)currentBuffer;
            if (this.isBufferInactive(builder)) {
                return bufferSource.getBuffer(renderType);
            }
        } else if (currentBuffer instanceof class_4618.class_4586) {
            class_4618.class_4586 outline = (class_4618.class_4586)currentBuffer;
            if (this.needsBufferRefresh(outline.field_20897)) {
                return new class_4618.class_4586(bufferSource.getBuffer(renderType), 255, 255, 255, 255);
            }
        } else if (currentBuffer instanceof class_4720.class_4589) {
            class_4720.class_4589 pair = (class_4720.class_4589)currentBuffer;
            class_4588 firstBuffer = pair.field_21685;
            class_4588 secondBuffer = pair.field_21686;
            boolean firstNeedsRefresh = this.needsBufferRefresh(firstBuffer);
            boolean secondNeedsRefresh = this.needsBufferRefresh(secondBuffer);
            if (firstNeedsRefresh || secondNeedsRefresh) {
                return new class_4720.class_4589(firstNeedsRefresh ? bufferSource.getBuffer(renderType) : firstBuffer, secondNeedsRefresh ? bufferSource.getBuffer(renderType) : secondBuffer);
            }
        }
        return currentBuffer;
    }

    private boolean needsBufferRefresh(class_4588 buffer) {
        if (buffer instanceof class_287) {
            class_287 builder = (class_287)buffer;
            return this.isBufferInactive(builder);
        }
        if (buffer instanceof class_4618.class_4586) {
            class_4618.class_4586 outline = (class_4618.class_4586)buffer;
            return this.needsBufferRefresh(outline.field_20897);
        }
        if (buffer instanceof class_4720.class_4589) {
            class_4720.class_4589 pair = (class_4720.class_4589)buffer;
            return this.needsBufferRefresh(pair.field_21685) || this.needsBufferRefresh(pair.field_21686);
        }
        return false;
    }

    private boolean isBufferInactive(class_287 builder) {
        return !builder.field_1556;
    }
}

