/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.layer;

import mod.azure.azurelib.cache.texture.AutoGlowingTexture;
import mod.azure.azurelib.model.AzBone;
import mod.azure.azurelib.render.AzRendererConfig;
import mod.azure.azurelib.render.AzRendererPipeline;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.layer.AzRenderLayer;
import mod.azure.azurelib.util.client.ClientUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class AzAutoGlowingLayer<K, T>
implements AzRenderLayer<K, T> {
    @Override
    public void preRender(AzRendererPipelineContext<K, T> context) {
    }

    @Override
    public void render(AzRendererPipelineContext<K, T> context) {
        AzRendererPipeline<K, T> renderPipeline = context.rendererPipeline();
        class_1921 renderType = this.determineRenderType(context);
        if (renderType != null) {
            context.setRenderType(renderType);
            context.setPackedLight(this.getPackedLight(context));
            context.setVertexConsumer(context.multiBufferSource().getBuffer(renderType));
            renderPipeline.reRender(context);
        }
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<K, T> context, AzBone bone) {
    }

    protected int getPackedLight(AzRendererPipelineContext<K, T> context) {
        return 0xF00000;
    }

    protected class_1921 determineRenderType(AzRendererPipelineContext<K, T> context) {
        T animatable = context.animatable();
        AzRendererConfig<K, T> config = context.rendererPipeline().config();
        class_2960 textureLocation = config.textureLocation(context.currentEntity(), animatable);
        if (!(animatable instanceof class_1297)) {
            return AutoGlowingTexture.getRenderType(textureLocation);
        }
        class_1297 entity = (class_1297)animatable;
        boolean isInvisible = entity.method_5767();
        boolean appearsGlowing = class_310.method_1551().method_27022(entity);
        boolean isPlayerInvisible = entity.method_5756(ClientUtils.getClientPlayer());
        if (isInvisible) {
            if (!isPlayerInvisible) {
                return class_1921.method_29379((class_2960)AutoGlowingTexture.getEmissiveResource(textureLocation));
            }
            if (appearsGlowing) {
                return class_1921.method_23287((class_2960)AutoGlowingTexture.getEmissiveResource(textureLocation));
            }
            return null;
        }
        if (appearsGlowing) {
            return AutoGlowingTexture.getOutlineRenderType(textureLocation);
        }
        return AutoGlowingTexture.getRenderType(textureLocation);
    }
}

