/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.AzureLibException;
import mod.azure.azurelib.rewrite.AzResourceCache;
import mod.azure.azurelib.rewrite.animation.cache.AzBakedAnimationCache;
import mod.azure.azurelib.rewrite.model.cache.AzBakedModelCache;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3695;

public final class AzureLibCache {
    public static void registerReloadListener() {
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return;
        }
        class_3300 class_33002 = mc.method_1478();
        if (!(class_33002 instanceof class_3304)) {
            throw new AzureLibException("AzureLib was initialized too early!");
        }
        class_3304 resourceManager = (class_3304)class_33002;
        resourceManager.method_14477(AzureLibCache::reload);
    }

    public static CompletableFuture<Void> reload(class_3302.class_4045 stage, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.allOf(AzBakedAnimationCache.getInstance().loadAnimations(backgroundExecutor, resourceManager), AzBakedModelCache.getInstance().loadModels(backgroundExecutor, resourceManager)).thenCompose(arg_0 -> ((class_3302.class_4045)stage).method_18352(arg_0))).thenAcceptAsync(empty -> {}, gameExecutor);
    }

    private static <T> CompletableFuture<Void> loadResources(Executor executor, class_3300 resourceManager, String type, Function<class_2960, T> loader, BiConsumer<class_2960, T> map) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> resourceManager.method_14488(type, fileName -> fileName.toString().endsWith(".json")), executor).thenApplyAsync(resources -> {
            Object2ObjectOpenHashMap tasks = new Object2ObjectOpenHashMap();
            for (class_2960 resource : resources.keySet()) {
                tasks.put(resource, CompletableFuture.supplyAsync(() -> loader.apply(resource), executor));
            }
            return tasks;
        }, executor)).thenAcceptAsync(tasks -> {
            for (Map.Entry entry : tasks.entrySet()) {
                if (AzResourceCache.EXCLUDED_NAMESPACES.contains(((class_2960)entry.getKey()).method_12836().toLowerCase(Locale.ROOT))) continue;
                map.accept((class_2960)entry.getKey(), ((CompletableFuture)entry.getValue()).join());
            }
        }, executor);
    }
}

