/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.entity;

import mod.azure.azurelib.rewrite.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipeline;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_922;

public class AzEntityModelRenderer<T extends class_1297>
extends AzModelRenderer<T> {
    protected final AzEntityRendererPipeline<T> entityRendererPipeline;

    public AzEntityModelRenderer(AzEntityRendererPipeline<T> entityRendererPipeline, AzLayerRenderer<T> layerRenderer) {
        super(entityRendererPipeline, layerRenderer);
        this.entityRendererPipeline = entityRendererPipeline;
    }

    @Override
    public void render(AzRendererPipelineContext<T> context, boolean isReRender) {
        AzEntityAnimator<T> animator;
        float f;
        class_1309 livingEntity;
        class_2350 bedDirection;
        class_1297 animatable = (class_1297)context.animatable();
        float partialTick = context.partialTick();
        class_4587 poseStack = context.poseStack();
        poseStack.method_22903();
        float lerpBodyRot = AzEntityModelRenderer.getLerpRot(animatable, partialTick);
        if (animatable.method_18376() == class_4050.field_18078 && animatable instanceof class_1309 && (bedDirection = (livingEntity = (class_1309)animatable).method_18401()) != null) {
            float eyePosOffset = livingEntity.method_18381(class_4050.field_18076) - 0.1f;
            poseStack.method_22904((double)((float)(-bedDirection.method_10148()) * eyePosOffset), 0.0, (double)((float)(-bedDirection.method_10165()) * eyePosOffset));
        }
        if (animatable instanceof class_1309) {
            class_1309 livingEntity2 = (class_1309)animatable;
            f = livingEntity2.method_17825();
        } else {
            f = 1.0f;
        }
        float nativeScale = f;
        float ageInTicks = (float)animatable.field_6012 + partialTick;
        poseStack.method_22905(nativeScale, nativeScale, nativeScale);
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick, nativeScale);
        if (!isReRender && (animator = this.entityRendererPipeline.getRenderer().getAnimator()) != null) {
            this.handleAnimation(animator, animatable, context.partialTick());
        }
        this.entityRendererPipeline.modelRenderTranslations.method_35434(poseStack.method_23760().method_23761());
        if (context.vertexConsumer() != null) {
            super.render(context, isReRender);
        }
        poseStack.method_22909();
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        class_4588 buffer = context.vertexConsumer();
        class_4597 bufferSource = context.multiBufferSource();
        class_1297 entity = (class_1297)context.animatable();
        class_4587 poseStack = context.poseStack();
        poseStack.method_22903();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            class_1159 poseState = new class_1159(poseStack.method_23760().method_23761());
            class_1159 localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRendererPipeline.entityRenderTranslations);
            class_1159 worldState = localMatrix.method_22673();
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(localMatrix);
            worldState.method_22671(new class_1160(entity.method_19538()));
            bone.setWorldSpaceMatrix(worldState);
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        context.setVertexConsumer(this.getOrRefreshRenderBuffer(isReRender, context, bone));
        if (!this.boneRenderOverride(poseStack, bone, bufferSource, buffer, context.partialTick(), context.packedLight(), context.packedOverlay(), context.red(), context.green(), context.blue(), context.alpha())) {
            super.renderCubesOfBone(context, bone);
        }
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.method_22909();
    }

    private static <T extends class_1297> float getLerpRot(T animatable, float partialTick) {
        class_1297 class_12972;
        float lerpHeadRot;
        float lerpBodyRot;
        boolean shouldSit;
        boolean bl = shouldSit = animatable.method_5765() && animatable.method_5854() != null;
        if (animatable instanceof class_1309) {
            class_1309 livingEntity = (class_1309)animatable;
            v1 = class_3532.method_17821((float)partialTick, (float)livingEntity.field_6220, (float)livingEntity.field_6283);
        } else {
            v1 = lerpBodyRot = animatable.method_36454();
        }
        if (animatable instanceof class_1309) {
            class_1309 livingEntity = (class_1309)animatable;
            v2 = class_3532.method_17821((float)partialTick, (float)livingEntity.field_6259, (float)livingEntity.field_6241);
        } else {
            v2 = lerpHeadRot = animatable.method_5791();
        }
        if (shouldSit && (class_12972 = animatable.method_5854()) instanceof class_1309) {
            class_1309 livingentity = (class_1309)class_12972;
            lerpBodyRot = class_3532.method_17821((float)partialTick, (float)livingentity.field_6220, (float)livingentity.field_6283);
            float netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = class_3532.method_15363((float)class_3532.method_15393((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
        }
        return lerpBodyRot;
    }

    protected void applyRotations(T animatable, class_4587 poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        this.applyRotations(animatable, poseStack, ageInTicks, rotationYaw, partialTick, 1.0f);
    }

    protected void applyRotations(T animatable, class_4587 poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        if (animatable.method_32314()) {
            rotationYaw += (float)(Math.cos((double)((class_1297)animatable).field_6012 * 3.25) * Math.PI * 0.4);
        }
        if (!animatable.method_41328(class_4050.field_18078)) {
            poseStack.method_22907(class_1160.field_20705.method_23214(180.0f - rotationYaw));
        }
        if (animatable instanceof class_1309) {
            class_1309 livingEntity = (class_1309)animatable;
            AzEntityRendererConfig<T> config = this.entityRendererPipeline.getRenderer().config();
            float deathMaxRotation = config.getDeathMaxRotation(animatable);
            if (livingEntity.field_6213 > 0) {
                float deathRotation = ((float)livingEntity.field_6213 + partialTick - 1.0f) / 20.0f * 1.6f;
                poseStack.method_22907(class_1160.field_20707.method_23214(Math.min(class_3532.method_15355((float)deathRotation), 1.0f) * deathMaxRotation));
            } else if (livingEntity.method_6123()) {
                poseStack.method_22907(class_1160.field_20703.method_23214(-90.0f - livingEntity.method_36455()));
                poseStack.method_22907(class_1160.field_20705.method_23214(((float)livingEntity.field_6012 + partialTick) * -75.0f));
            } else if (animatable.method_41328(class_4050.field_18078)) {
                class_2350 bedOrientation = livingEntity.method_18401();
                poseStack.method_22907(class_1160.field_20705.method_23214(bedOrientation != null ? RenderUtils.getDirectionAngle(bedOrientation) : rotationYaw));
                poseStack.method_22907(class_1160.field_20707.method_23214(deathMaxRotation));
                poseStack.method_22907(class_1160.field_20705.method_23214(270.0f));
            } else if (class_922.method_38563((class_1309)livingEntity)) {
                poseStack.method_22904(0.0, (double)((animatable.method_17682() + 0.1f) / nativeScale), 0.0);
                poseStack.method_22907(class_1160.field_20707.method_23214(180.0f));
            }
        }
    }
}

