/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.animation.controller.keyframe;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleSupplier;
import mod.azure.azurelib.common.animation.controller.AzAnimationController;
import mod.azure.azurelib.common.animation.controller.AzAnimationControllerTimer;
import mod.azure.azurelib.common.animation.controller.AzBoneAnimationQueueCache;
import mod.azure.azurelib.common.animation.controller.keyframe.AzAbstractKeyframeExecutor;
import mod.azure.azurelib.common.animation.controller.keyframe.AzAnimationPoint;
import mod.azure.azurelib.common.animation.controller.keyframe.AzBoneAnimation;
import mod.azure.azurelib.common.animation.controller.keyframe.AzBoneAnimationQueue;
import mod.azure.azurelib.common.animation.controller.keyframe.AzKeyframe;
import mod.azure.azurelib.common.animation.controller.keyframe.AzKeyframeCallbackHandler;
import mod.azure.azurelib.common.animation.controller.keyframe.AzKeyframeStack;
import mod.azure.azurelib.common.animation.primitive.AzQueuedAnimation;
import mod.azure.azurelib.core.math.IValue;
import mod.azure.azurelib.core.molang.MolangParser;
import mod.azure.azurelib.core.molang.MolangQueries;
import mod.azure.azurelib.core.object.Axis;
import org.jetbrains.annotations.NotNull;

public class AzKeyframeExecutor<T>
extends AzAbstractKeyframeExecutor {
    private final AzAnimationController<T> animationController;
    private final AzBoneAnimationQueueCache<T> boneAnimationQueueCache;
    private double currentAnimTimeSeconds;
    private final DoubleSupplier animTimeSupplier = () -> this.currentAnimTimeSeconds;
    private final Map<String, BoneCache> boneCache = new HashMap<String, BoneCache>();
    protected static final AzAnimationPoint EMPTY_POINT = new AzAnimationPoint(null, 0.0, 0.0, 0.0, 0.0);

    public AzKeyframeExecutor(AzAnimationController<T> animationController, AzBoneAnimationQueueCache<T> boneAnimationQueueCache) {
        this.animationController = animationController;
        this.boneAnimationQueueCache = boneAnimationQueueCache;
    }

    public void execute(@NotNull AzQueuedAnimation currentAnimation, T animatable, boolean crashWhenCantFindBone) {
        AzKeyframeCallbackHandler<T> keyframeCallbackHandler = this.animationController.keyframeManager().keyframeCallbackHandler();
        AzAnimationControllerTimer<T> controllerTimer = this.animationController.controllerTimer();
        double adjustedTick = controllerTimer.getAdjustedTick();
        this.currentAnimTimeSeconds = adjustedTick / 20.0;
        MolangParser.INSTANCE.setMemoizedValue(MolangQueries.ANIM_TIME, this.animTimeSupplier);
        for (AzBoneAnimation boneAnimation : currentAnimation.animation().boneAnimations()) {
            String boneName = boneAnimation.boneName();
            AzBoneAnimationQueue boneQueue = this.boneAnimationQueueCache.getOrNull(boneName);
            if (boneQueue == null) {
                if (!crashWhenCantFindBone) continue;
                throw new NoSuchElementException("Could not find bone: " + boneName);
            }
            BoneCache cache = this.boneCache.computeIfAbsent(boneName, n -> new BoneCache());
            if (cache.lastTick == adjustedTick) continue;
            cache.lastTick = adjustedTick;
            AzKeyframeStack<AzKeyframe<IValue>> rot = boneAnimation.rotationKeyframes();
            AzKeyframeStack<AzKeyframe<IValue>> pos = boneAnimation.positionKeyframes();
            AzKeyframeStack<AzKeyframe<IValue>> scl = boneAnimation.scaleKeyframes();
            if (this.stackIsNotEmpty(rot)) {
                this.updateRotation(rot, boneQueue, adjustedTick, cache);
            }
            if (this.stackIsNotEmpty(pos)) {
                this.updatePosition(pos, boneQueue, adjustedTick, cache);
            }
            if (!this.stackIsNotEmpty(scl)) continue;
            this.updateScale(scl, boneQueue, adjustedTick, cache);
        }
        keyframeCallbackHandler.handle(animatable, adjustedTick);
    }

    private boolean stackIsNotEmpty(AzKeyframeStack<?> stack) {
        return !stack.xKeyframes().isEmpty() || !stack.yKeyframes().isEmpty() || !stack.zKeyframes().isEmpty();
    }

    private void updateRotation(AzKeyframeStack<AzKeyframe<IValue>> keyframes, AzBoneAnimationQueue queue, double tick, BoneCache cache) {
        AzAnimationPoint newX = this.getAnimationPointAtTick(keyframes.xKeyframes(), tick, true, Axis.X);
        AzAnimationPoint newY = this.getAnimationPointAtTick(keyframes.yKeyframes(), tick, true, Axis.Y);
        AzAnimationPoint newZ = this.getAnimationPointAtTick(keyframes.zKeyframes(), tick, true, Axis.Z);
        if (cache.rotX != EMPTY_POINT && cache.rotX != newX) {
            AzKeyframeExecutor.recyclePoint(cache.rotX);
        }
        if (cache.rotY != EMPTY_POINT && cache.rotY != newY) {
            AzKeyframeExecutor.recyclePoint(cache.rotY);
        }
        if (cache.rotZ != EMPTY_POINT && cache.rotZ != newZ) {
            AzKeyframeExecutor.recyclePoint(cache.rotZ);
        }
        cache.rotX = AzKeyframeExecutor.getOrDefault(newX, cache.rotX);
        cache.rotY = AzKeyframeExecutor.getOrDefault(newY, cache.rotY);
        cache.rotZ = AzKeyframeExecutor.getOrDefault(newZ, cache.rotZ);
        queue.addRotations(cache.rotX, cache.rotY, cache.rotZ);
    }

    private void updatePosition(AzKeyframeStack<AzKeyframe<IValue>> keyframes, AzBoneAnimationQueue queue, double tick, BoneCache cache) {
        AzAnimationPoint newX = this.getAnimationPointAtTick(keyframes.xKeyframes(), tick, false, Axis.X);
        AzAnimationPoint newY = this.getAnimationPointAtTick(keyframes.yKeyframes(), tick, false, Axis.Y);
        AzAnimationPoint newZ = this.getAnimationPointAtTick(keyframes.zKeyframes(), tick, false, Axis.Z);
        if (cache.posX != EMPTY_POINT && cache.posX != newX) {
            AzKeyframeExecutor.recyclePoint(cache.posX);
        }
        if (cache.posY != EMPTY_POINT && cache.posY != newY) {
            AzKeyframeExecutor.recyclePoint(cache.posY);
        }
        if (cache.posZ != EMPTY_POINT && cache.posZ != newZ) {
            AzKeyframeExecutor.recyclePoint(cache.posZ);
        }
        cache.posX = AzKeyframeExecutor.getOrDefault(newX, cache.posX);
        cache.posY = AzKeyframeExecutor.getOrDefault(newY, cache.posY);
        cache.posZ = AzKeyframeExecutor.getOrDefault(newZ, cache.posZ);
        queue.addPositions(cache.posX, cache.posY, cache.posZ);
    }

    private void updateScale(AzKeyframeStack<AzKeyframe<IValue>> keyframes, AzBoneAnimationQueue queue, double tick, BoneCache cache) {
        AzAnimationPoint newX = this.getAnimationPointAtTick(keyframes.xKeyframes(), tick, false, Axis.X);
        AzAnimationPoint newY = this.getAnimationPointAtTick(keyframes.yKeyframes(), tick, false, Axis.Y);
        AzAnimationPoint newZ = this.getAnimationPointAtTick(keyframes.zKeyframes(), tick, false, Axis.Z);
        if (cache.sclX != EMPTY_POINT && cache.sclX != newX) {
            AzKeyframeExecutor.recyclePoint(cache.sclX);
        }
        if (cache.sclY != EMPTY_POINT && cache.sclY != newY) {
            AzKeyframeExecutor.recyclePoint(cache.sclY);
        }
        if (cache.sclZ != EMPTY_POINT && cache.sclZ != newZ) {
            AzKeyframeExecutor.recyclePoint(cache.sclZ);
        }
        cache.sclX = AzKeyframeExecutor.getOrDefault(newX, cache.sclX);
        cache.sclY = AzKeyframeExecutor.getOrDefault(newY, cache.sclY);
        cache.sclZ = AzKeyframeExecutor.getOrDefault(newZ, cache.sclZ);
        queue.addScales(cache.sclX, cache.sclY, cache.sclZ);
    }

    private static AzAnimationPoint getOrDefault(AzAnimationPoint value, AzAnimationPoint fallback) {
        return value != null ? value : fallback;
    }

    private static class BoneCache {
        double lastTick = -1.0;
        AzAnimationPoint rotX = EMPTY_POINT;
        AzAnimationPoint rotY = EMPTY_POINT;
        AzAnimationPoint rotZ = EMPTY_POINT;
        AzAnimationPoint posX = EMPTY_POINT;
        AzAnimationPoint posY = EMPTY_POINT;
        AzAnimationPoint posZ = EMPTY_POINT;
        AzAnimationPoint sclX = EMPTY_POINT;
        AzAnimationPoint sclY = EMPTY_POINT;
        AzAnimationPoint sclZ = EMPTY_POINT;

        private BoneCache() {
        }
    }
}

