/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.model;

import mod.azure.azurelib.common.model.AzBone;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AzBoneSnapshot {
    private final AzBone bone;
    private final Vector3f offsetPosition;
    private final Vector3f rotation;
    private final Vector3f scale;
    private double lastResetRotationTick = 0.0;
    private double lastResetPositionTick = 0.0;
    private double lastResetScaleTick = 0.0;
    private boolean rotAnimInProgress = true;
    private boolean posAnimInProgress = true;
    private boolean scaleAnimInProgress = true;

    public AzBoneSnapshot(AzBone bone) {
        this.bone = bone;
        this.offsetPosition = new Vector3f(bone.getPosX(), bone.getPosY(), bone.getPosZ());
        this.rotation = new Vector3f(bone.getRotX(), bone.getRotY(), bone.getRotZ());
        this.scale = new Vector3f(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static AzBoneSnapshot copy(AzBoneSnapshot snapshot) {
        AzBoneSnapshot newSnapshot = new AzBoneSnapshot(snapshot.bone);
        newSnapshot.offsetPosition.set((Vector3fc)snapshot.offsetPosition);
        newSnapshot.rotation.set((Vector3fc)snapshot.rotation);
        newSnapshot.scale.set((Vector3fc)snapshot.scale);
        return newSnapshot;
    }

    public AzBone getBone() {
        return this.bone;
    }

    public float getScaleX() {
        return this.scale.x;
    }

    public float getScaleY() {
        return this.scale.y;
    }

    public float getScaleZ() {
        return this.scale.z;
    }

    public float getOffsetX() {
        return this.offsetPosition.x;
    }

    public float getOffsetY() {
        return this.offsetPosition.y;
    }

    public float getOffsetZ() {
        return this.offsetPosition.z;
    }

    public float getRotX() {
        return this.rotation.x;
    }

    public float getRotY() {
        return this.rotation.y;
    }

    public float getRotZ() {
        return this.rotation.z;
    }

    public double getLastResetRotationTick() {
        return this.lastResetRotationTick;
    }

    public double getLastResetPositionTick() {
        return this.lastResetPositionTick;
    }

    public double getLastResetScaleTick() {
        return this.lastResetScaleTick;
    }

    public boolean isRotAnimInProgress() {
        return this.rotAnimInProgress;
    }

    public boolean isPosAnimInProgress() {
        return this.posAnimInProgress;
    }

    public boolean isScaleAnimInProgress() {
        return this.scaleAnimInProgress;
    }

    public void updateScale(float scaleX, float scaleY, float scaleZ) {
        this.scale.set(scaleX, scaleY, scaleZ);
    }

    public void updateOffset(float offsetX, float offsetY, float offsetZ) {
        this.offsetPosition.set(offsetX, offsetY, offsetZ);
    }

    public void updateRotation(float rotX, float rotY, float rotZ) {
        this.rotation.set(rotX, rotY, rotZ);
    }

    public void startPosAnim() {
        this.posAnimInProgress = true;
    }

    public void stopPosAnim(double tick) {
        this.posAnimInProgress = false;
        this.lastResetPositionTick = tick;
    }

    public void startRotAnim() {
        this.rotAnimInProgress = true;
    }

    public void stopRotAnim(double tick) {
        this.rotAnimInProgress = false;
        this.lastResetRotationTick = tick;
    }

    public void startScaleAnim() {
        this.scaleAnimInProgress = true;
    }

    public void stopScaleAnim(double tick) {
        this.scaleAnimInProgress = false;
        this.lastResetScaleTick = tick;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return this.bone.getName().hashCode();
    }
}

